"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePolicies = usePolicies;
var _reactQuery = require("@tanstack/react-query");
var _use_kibana = require("../../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const POLICIES_URL = '/api/fleet/package_policies';
const PACKAGE_POLICY_SAVED_OBJECT_TYPE = 'ingest-package-policies';
function usePolicies() {
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  const queryKey = ['policies'];
  const fetchPolicies = () => http.get(POLICIES_URL, {
    query: {
      withAgentCount: true,
      kuery: `${PACKAGE_POLICY_SAVED_OBJECT_TYPE}.package.name: endpoint`
    }
  });
  return (0, _reactQuery.useQuery)(queryKey, fetchPolicies, {
    select: data => data.items
  });
}