"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.taskModelVersions = void 0;
var _task = require("../schemas/task");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// IMPORTANT!!!
// When adding new model versions, make sure to manually test
// downgrading to the previous version. This is a gap in our
// automated test coverage so manual testing is needed.
const taskModelVersions = exports.taskModelVersions = {
  '1': {
    changes: [{
      type: 'mappings_deprecation',
      deprecatedMappings: ['numSkippedRuns', 'interval']
    }],
    schemas: {
      forwardCompatibility: _task.taskSchemaV1.extends({}, {
        unknowns: 'ignore'
      }),
      create: _task.taskSchemaV1
    }
  },
  '2': {
    changes: [{
      type: 'mappings_addition',
      addedMappings: {
        partition: {
          type: 'integer'
        }
      }
    }],
    schemas: {
      forwardCompatibility: _task.taskSchemaV2.extends({}, {
        unknowns: 'ignore'
      }),
      create: _task.taskSchemaV2
    }
  },
  '3': {
    changes: [{
      type: 'mappings_addition',
      addedMappings: {
        priority: {
          type: 'integer'
        }
      }
    }],
    schemas: {
      forwardCompatibility: _task.taskSchemaV3.extends({}, {
        unknowns: 'ignore'
      }),
      create: _task.taskSchemaV3
    }
  },
  '4': {
    changes: [{
      type: 'mappings_addition',
      addedMappings: {
        userScope: {
          properties: {
            apiKeyId: {
              type: 'keyword'
            }
          }
        }
      }
    }],
    schemas: {
      forwardCompatibility: _task.taskSchemaV4.extends({}, {
        unknowns: 'ignore'
      }),
      create: _task.taskSchemaV4
    }
  },
  '5': {
    changes: [],
    schemas: {
      forwardCompatibility: _task.taskSchemaV5.extends({}, {
        unknowns: 'ignore'
      }),
      create: _task.taskSchemaV5
    }
  },
  '6': {
    changes: [],
    schemas: {
      forwardCompatibility: _task.taskSchemaV6.extends({}, {
        unknowns: 'ignore'
      }),
      create: _task.taskSchemaV6
    }
  }
};