"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TaskOverdueMetricsAggregator = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _saferLodashSet = require("@kbn/safer-lodash-set");
var _result_type = require("../lib/result_type");
var _lib = require("./lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HDR_HISTOGRAM_MAX = 5400; // 90 minutes
const HDR_HISTOGRAM_BUCKET_SIZE = 10; // 10 seconds

const OVERDUE_BY_KEY = 'overdue_by';
const OVERDUE_BY_VALUES_KEY = 'overdue_by_values';
var TaskOverdueMetricKeys = /*#__PURE__*/function (TaskOverdueMetricKeys) {
  TaskOverdueMetricKeys["OVERALL"] = "overall";
  TaskOverdueMetricKeys["BY_TYPE"] = "by_type";
  return TaskOverdueMetricKeys;
}(TaskOverdueMetricKeys || {});
class TaskOverdueMetricsAggregator {
  constructor() {
    (0, _defineProperty2.default)(this, "histograms", {});
  }
  initialMetric() {
    return {
      by_type: {},
      overall: {
        overdue_by: {
          counts: [],
          values: []
        },
        overdue_by_values: []
      }
    };
  }
  collect() {
    const result = this.initialMetric();
    if ((0, _lodash.keys)(this.histograms).length === 0) {
      return result;
    }
    for (const prop of Object.keys(this.histograms)) {
      const hist = this.histograms[prop];
      (0, _saferLodashSet.set)(result, prop, hist.serialize());
      (0, _saferLodashSet.set)(result, `${prop}_values`, hist.getAllValues());
    }
    return result;
  }
  reset() {
    // no-op because this metric is not a counter
  }
  processTaskLifecycleEvent(taskEvent) {
    this.histograms = {};
    let metric;
    if ((0, _result_type.isOk)(taskEvent.event)) {
      metric = (0, _result_type.unwrap)(taskEvent.event);
      for (const key of Object.keys(metric.numOverdueTasks)) {
        var _metric$numOverdueTas;
        const hist = new _lib.SimpleHistogram(HDR_HISTOGRAM_MAX, HDR_HISTOGRAM_BUCKET_SIZE);
        ((_metric$numOverdueTas = metric.numOverdueTasks[key]) !== null && _metric$numOverdueTas !== void 0 ? _metric$numOverdueTas : []).forEach(bucket => {
          const overdueInSec = parseInt(bucket.key, 10);
          hist.record(overdueInSec, bucket.doc_count);
          if (key === 'total') {
            this.histograms[`${TaskOverdueMetricKeys.OVERALL}.${OVERDUE_BY_KEY}`] = hist;
          } else {
            const taskType = key.replaceAll('.', '__');
            const taskTypeGroup = (0, _lib.getTaskTypeGroup)(taskType);
            this.histograms[`${TaskOverdueMetricKeys.BY_TYPE}.${taskType}.${OVERDUE_BY_KEY}`] = hist;
            if (taskTypeGroup) {
              var _this$histograms;
              const groupHist = (_this$histograms = this.histograms[`${TaskOverdueMetricKeys.BY_TYPE}.${taskTypeGroup}.${OVERDUE_BY_KEY}`]) !== null && _this$histograms !== void 0 ? _this$histograms : new _lib.SimpleHistogram(HDR_HISTOGRAM_MAX, HDR_HISTOGRAM_BUCKET_SIZE);
              groupHist.record(overdueInSec, bucket.doc_count);
              this.histograms[`${TaskOverdueMetricKeys.BY_TYPE}.${taskTypeGroup}.${OVERDUE_BY_KEY}`] = groupHist;
            }
          }
        });
      }
    }
  }
}
exports.TaskOverdueMetricsAggregator = TaskOverdueMetricsAggregator;