"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.taskExecutionFailureThresholdSchema = exports.configSchema = exports.WORKER_UTILIZATION_RUNNING_AVERAGE_WINDOW_SIZE_MS = exports.MIN_CAPACITY = exports.MGET_DEFAULT_POLL_INTERVAL = exports.MAX_WORKERS_LIMIT = exports.MAX_CAPACITY = exports.DISCOVERY_INTERVAL_AFTER_BLOCK_EXCEPTION_MS = exports.DEFAULT_WORKER_UTILIZATION_RUNNING_AVERAGE_WINDOW = exports.DEFAULT_VERSION_CONFLICT_THRESHOLD = exports.DEFAULT_POLL_INTERVAL = exports.DEFAULT_MONITORING_STATS_WARN_DELAYED_TASK_START_IN_SECONDS = exports.DEFAULT_MONITORING_STATS_RUNNING_AVERAGE_WINDOW = exports.DEFAULT_MONITORING_REFRESH_RATE = exports.DEFAULT_METRICS_RESET_INTERVAL = exports.DEFAULT_MAX_WORKERS = exports.DEFAULT_MAX_EPHEMERAL_REQUEST_CAPACITY = exports.DEFAULT_KIBANAS_PER_PARTITION = exports.DEFAULT_DISCOVERY_INTERVAL_MS = exports.DEFAULT_CAPACITY = exports.DEFAULT_ACTIVE_NODES_LOOK_BACK_DURATION = exports.CLAIM_STRATEGY_UPDATE_BY_QUERY = exports.CLAIM_STRATEGY_MGET = void 0;
var _configSchema = require("@kbn/config-schema");
var _intervals = require("./lib/intervals");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_WORKERS_LIMIT = exports.MAX_WORKERS_LIMIT = 100;
const DEFAULT_CAPACITY = exports.DEFAULT_CAPACITY = 10;
const MAX_CAPACITY = exports.MAX_CAPACITY = 50;
const MIN_CAPACITY = exports.MIN_CAPACITY = 5;
const DEFAULT_MAX_WORKERS = exports.DEFAULT_MAX_WORKERS = 10;
const DEFAULT_POLL_INTERVAL = exports.DEFAULT_POLL_INTERVAL = 3000;
const MGET_DEFAULT_POLL_INTERVAL = exports.MGET_DEFAULT_POLL_INTERVAL = 500;
const DEFAULT_VERSION_CONFLICT_THRESHOLD = exports.DEFAULT_VERSION_CONFLICT_THRESHOLD = 80;
const DEFAULT_MAX_EPHEMERAL_REQUEST_CAPACITY = exports.DEFAULT_MAX_EPHEMERAL_REQUEST_CAPACITY = MAX_WORKERS_LIMIT;

// Monitoring Constants
// ===================
// Refresh aggregated monitored stats at a default rate of once a minute
const DEFAULT_MONITORING_REFRESH_RATE = exports.DEFAULT_MONITORING_REFRESH_RATE = 60 * 1000;
const DEFAULT_MONITORING_STATS_RUNNING_AVERAGE_WINDOW = exports.DEFAULT_MONITORING_STATS_RUNNING_AVERAGE_WINDOW = 50;
const DEFAULT_MONITORING_STATS_WARN_DELAYED_TASK_START_IN_SECONDS = exports.DEFAULT_MONITORING_STATS_WARN_DELAYED_TASK_START_IN_SECONDS = 60;
const DEFAULT_METRICS_RESET_INTERVAL = exports.DEFAULT_METRICS_RESET_INTERVAL = 30 * 1000; // 30 seconds

// At the default poll interval of 3sec, this averages over the last 15sec.
const DEFAULT_WORKER_UTILIZATION_RUNNING_AVERAGE_WINDOW = exports.DEFAULT_WORKER_UTILIZATION_RUNNING_AVERAGE_WINDOW = 5;
const WORKER_UTILIZATION_RUNNING_AVERAGE_WINDOW_SIZE_MS = exports.WORKER_UTILIZATION_RUNNING_AVERAGE_WINDOW_SIZE_MS = 15 * 1000; // 15 seconds

const CLAIM_STRATEGY_UPDATE_BY_QUERY = exports.CLAIM_STRATEGY_UPDATE_BY_QUERY = 'update_by_query';
const CLAIM_STRATEGY_MGET = exports.CLAIM_STRATEGY_MGET = 'mget';
const DEFAULT_DISCOVERY_INTERVAL_MS = exports.DEFAULT_DISCOVERY_INTERVAL_MS = 1000 * 10; // 10 seconds
const MIN_DISCOVERY_INTERVAL_MS = 1000; // 1 second
const MAX_DISCOVERY_INTERVAL_MS = 1000 * 60 * 5; // 5 minutes
const DISCOVERY_INTERVAL_AFTER_BLOCK_EXCEPTION_MS = exports.DISCOVERY_INTERVAL_AFTER_BLOCK_EXCEPTION_MS = 6 * 1000 * 10; // 60 seconds

const DEFAULT_ACTIVE_NODES_LOOK_BACK_DURATION = exports.DEFAULT_ACTIVE_NODES_LOOK_BACK_DURATION = '30s';
const FIVE_MIN_IN_MS = 5 * 60 * 1000;
const DEFAULT_KIBANAS_PER_PARTITION = exports.DEFAULT_KIBANAS_PER_PARTITION = 2;
const taskExecutionFailureThresholdSchema = exports.taskExecutionFailureThresholdSchema = _configSchema.schema.object({
  error_threshold: _configSchema.schema.number({
    defaultValue: 90,
    min: 0
  }),
  warn_threshold: _configSchema.schema.number({
    defaultValue: 80,
    min: 0
  })
}, {
  validate(config) {
    if (config.error_threshold < config.warn_threshold) {
      return `warn_threshold (${config.warn_threshold}) must be less than, or equal to, error_threshold (${config.error_threshold})`;
    }
  }
});
const eventLoopDelaySchema = _configSchema.schema.object({
  monitor: _configSchema.schema.boolean({
    defaultValue: true
  }),
  warn_threshold: _configSchema.schema.number({
    defaultValue: 5000,
    min: 10
  })
});
const requestTimeoutsConfig = _configSchema.schema.object({
  /* The request timeout config for task manager's updateByQuery default:30s, min:10s, max:10m */
  update_by_query: _configSchema.schema.number({
    defaultValue: 1000 * 30,
    min: 1000 * 10,
    max: 1000 * 60 * 10
  })
});
const configSchema = exports.configSchema = _configSchema.schema.object({
  allow_reading_invalid_state: _configSchema.schema.boolean({
    defaultValue: true
  }),
  /* The number of normal cost tasks that this Kibana instance will run simultaneously */
  capacity: _configSchema.schema.maybe(_configSchema.schema.number({
    min: MIN_CAPACITY,
    max: MAX_CAPACITY
  })),
  discovery: _configSchema.schema.object({
    active_nodes_lookback: _configSchema.schema.string({
      defaultValue: DEFAULT_ACTIVE_NODES_LOOK_BACK_DURATION,
      validate: duration => {
        try {
          const parsedDurationMs = (0, _intervals.parseIntervalAsMillisecond)(duration);
          if (parsedDurationMs > FIVE_MIN_IN_MS) {
            return 'active node lookback duration cannot exceed five minutes';
          }
        } catch (err) {
          return 'active node lookback duration must be a valid duration string';
        }
      }
    }),
    interval: _configSchema.schema.number({
      defaultValue: DEFAULT_DISCOVERY_INTERVAL_MS,
      min: MIN_DISCOVERY_INTERVAL_MS,
      max: MAX_DISCOVERY_INTERVAL_MS
    })
  }),
  ephemeral_tasks: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: false
    }),
    /* How many requests can Task Manager buffer before it rejects new requests. */
    request_capacity: _configSchema.schema.number({
      // a nice round contrived number, feel free to change as we learn how it behaves
      defaultValue: 10,
      min: 1,
      max: DEFAULT_MAX_EPHEMERAL_REQUEST_CAPACITY
    })
  }),
  event_loop_delay: eventLoopDelaySchema,
  kibanas_per_partition: _configSchema.schema.number({
    defaultValue: DEFAULT_KIBANAS_PER_PARTITION,
    min: 1
  }),
  /* The maximum number of times a task will be attempted before being abandoned as failed */
  max_attempts: _configSchema.schema.number({
    defaultValue: 3,
    min: 1
  }),
  /* The maximum number of tasks that this Kibana instance will run simultaneously. */
  max_workers: _configSchema.schema.maybe(_configSchema.schema.number({
    // disable the task manager rather than trying to specify it with 0 workers
    min: 1
  })),
  /* The interval at which monotonically increasing metrics counters will reset */
  metrics_reset_interval: _configSchema.schema.number({
    defaultValue: DEFAULT_METRICS_RESET_INTERVAL,
    min: 10 * 1000 // minimum 10 seconds
  }),
  /* The rate at which we refresh monitored stats that require aggregation queries against ES. */
  monitored_aggregated_stats_refresh_rate: _configSchema.schema.number({
    defaultValue: DEFAULT_MONITORING_REFRESH_RATE,
    /* don't run monitored stat aggregations any faster than once every 5 seconds */
    min: 5000
  }),
  monitored_stats_health_verbose_log: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: false
    }),
    level: _configSchema.schema.oneOf([_configSchema.schema.literal('debug'), _configSchema.schema.literal('info')], {
      defaultValue: 'debug'
    }),
    /* The amount of seconds we allow a task to delay before printing a warning server log */
    warn_delayed_task_start_in_seconds: _configSchema.schema.number({
      defaultValue: DEFAULT_MONITORING_STATS_WARN_DELAYED_TASK_START_IN_SECONDS
    })
  }),
  /* The rate at which we emit fresh monitored stats. By default we'll use the poll_interval (+ a slight buffer) */
  monitored_stats_required_freshness: _configSchema.schema.number({
    defaultValue: config => {
      var _poll_interval;
      return ((_poll_interval = config === null || config === void 0 ? void 0 : config.poll_interval) !== null && _poll_interval !== void 0 ? _poll_interval : DEFAULT_POLL_INTERVAL) + 1000;
    },
    min: 100
  }),
  /* The size of the running average window for monitored stats. */
  monitored_stats_running_average_window: _configSchema.schema.number({
    defaultValue: DEFAULT_MONITORING_STATS_RUNNING_AVERAGE_WINDOW,
    max: 100,
    min: 10
  }),
  /* Task Execution result warn & error thresholds. */
  monitored_task_execution_thresholds: _configSchema.schema.object({
    custom: _configSchema.schema.recordOf(_configSchema.schema.string(), taskExecutionFailureThresholdSchema, {
      defaultValue: {}
    }),
    default: taskExecutionFailureThresholdSchema
  }),
  /* How often, in milliseconds, the task manager will look for more work. */
  poll_interval: _configSchema.schema.conditional(_configSchema.schema.siblingRef('claim_strategy'), CLAIM_STRATEGY_MGET, _configSchema.schema.number({
    defaultValue: MGET_DEFAULT_POLL_INTERVAL,
    min: 100
  }), _configSchema.schema.number({
    defaultValue: DEFAULT_POLL_INTERVAL,
    min: 100
  })),
  /* How many requests can Task Manager buffer before it rejects new requests. */
  request_capacity: _configSchema.schema.number({
    // a nice round contrived number, feel free to change as we learn how it behaves
    defaultValue: 1000,
    min: 1
  }),
  /* These are not designed to be used by most users. Please use caution when changing these */
  unsafe: _configSchema.schema.object({
    authenticate_background_task_utilization: _configSchema.schema.boolean({
      defaultValue: true
    }),
    exclude_task_types: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
      defaultValue: []
    })
  }),
  /* The threshold percenatge for workers experiencing version conflicts for shifting the polling interval. */
  version_conflict_threshold: _configSchema.schema.number({
    defaultValue: DEFAULT_VERSION_CONFLICT_THRESHOLD,
    min: 50,
    max: 100
  }),
  worker_utilization_running_average_window: _configSchema.schema.maybe(_configSchema.schema.number({
    max: 100,
    min: 1
  })),
  claim_strategy: _configSchema.schema.string({
    defaultValue: CLAIM_STRATEGY_MGET
  }),
  request_timeouts: requestTimeoutsConfig,
  auto_calculate_default_ech_capacity: _configSchema.schema.boolean({
    defaultValue: false
  })
}, {
  validate: config => {
    if (config.monitored_stats_required_freshness && config.poll_interval && config.monitored_stats_required_freshness < config.poll_interval) {
      return `The specified monitored_stats_required_freshness (${config.monitored_stats_required_freshness}) is invalid, as it is below the poll_interval (${config.poll_interval})`;
    }
  }
});