"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSyntheticsMonitorConfigSavedObjectType = exports.attributesToIncludeInAAD = exports.SYNTHETICS_MONITOR_ENCRYPTED_TYPE = void 0;
var _i18n = require("@kbn/i18n");
var _monitor_mappings = require("./monitor_mappings");
var _saved_objects = require("../../../common/types/saved_objects");
var _monitor_management = require("../../../common/constants/monitor_management");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSyntheticsMonitorConfigSavedObjectType = () => {
  return {
    name: _saved_objects.syntheticsMonitorSavedObjectType,
    hidden: false,
    namespaceType: 'multiple',
    mappings: _monitor_mappings.monitorConfigMappings,
    management: {
      importableAndExportable: false,
      icon: 'uptimeApp',
      getTitle: savedObject => _i18n.i18n.translate('xpack.synthetics.syntheticsMonitors.multiple.label', {
        defaultMessage: '{name} - (Synthetics Monitor)',
        values: {
          name: savedObject.attributes.name
        }
      })
    },
    modelVersions: {}
  };
};
exports.getSyntheticsMonitorConfigSavedObjectType = getSyntheticsMonitorConfigSavedObjectType;
const attributesToIncludeInAAD = exports.attributesToIncludeInAAD = new Set([_monitor_management.ConfigKey.APM_SERVICE_NAME, _monitor_management.ConfigKey.CUSTOM_HEARTBEAT_ID, _monitor_management.ConfigKey.CONFIG_ID, _monitor_management.ConfigKey.CONFIG_HASH, _monitor_management.ConfigKey.ENABLED, _monitor_management.ConfigKey.FORM_MONITOR_TYPE, _monitor_management.ConfigKey.HOSTS, _monitor_management.ConfigKey.IGNORE_HTTPS_ERRORS, _monitor_management.ConfigKey.MONITOR_SOURCE_TYPE, _monitor_management.ConfigKey.JOURNEY_FILTERS_MATCH, _monitor_management.ConfigKey.JOURNEY_FILTERS_TAGS, _monitor_management.ConfigKey.JOURNEY_ID, _monitor_management.ConfigKey.MAX_REDIRECTS, _monitor_management.ConfigKey.MODE, _monitor_management.ConfigKey.MONITOR_TYPE, _monitor_management.ConfigKey.NAME, _monitor_management.ConfigKey.NAMESPACE, _monitor_management.ConfigKey.LOCATIONS, _monitor_management.ConfigKey.PLAYWRIGHT_OPTIONS, _monitor_management.ConfigKey.ORIGINAL_SPACE, _monitor_management.ConfigKey.PORT, _monitor_management.ConfigKey.PROXY_URL, _monitor_management.ConfigKey.PROXY_USE_LOCAL_RESOLVER, _monitor_management.ConfigKey.RESPONSE_BODY_INDEX, _monitor_management.ConfigKey.RESPONSE_HEADERS_INDEX, _monitor_management.ConfigKey.RESPONSE_BODY_MAX_BYTES, _monitor_management.ConfigKey.RESPONSE_STATUS_CHECK, _monitor_management.ConfigKey.REQUEST_METHOD_CHECK, _monitor_management.ConfigKey.REVISION, _monitor_management.ConfigKey.SCHEDULE, _monitor_management.ConfigKey.SCREENSHOTS, _monitor_management.ConfigKey.IPV4, _monitor_management.ConfigKey.IPV6, _monitor_management.ConfigKey.PROJECT_ID, _monitor_management.ConfigKey.TEXT_ASSERTION, _monitor_management.ConfigKey.TLS_CERTIFICATE_AUTHORITIES, _monitor_management.ConfigKey.TLS_CERTIFICATE, _monitor_management.ConfigKey.TLS_VERIFICATION_MODE, _monitor_management.ConfigKey.TLS_VERSION, _monitor_management.ConfigKey.TAGS, _monitor_management.ConfigKey.TIMEOUT, _monitor_management.ConfigKey.THROTTLING_CONFIG, _monitor_management.ConfigKey.URLS, _monitor_management.ConfigKey.WAIT, _monitor_management.ConfigKey.MONITOR_QUERY_ID]);
const SYNTHETICS_MONITOR_ENCRYPTED_TYPE = exports.SYNTHETICS_MONITOR_ENCRYPTED_TYPE = {
  type: _saved_objects.syntheticsMonitorSavedObjectType,
  attributesToEncrypt: new Set(['secrets',
  /* adding secretKeys to the list of attributes to encrypt ensures
   * that secrets are never stored on the resulting saved object,
   * even in the presence of developer error.
   *
   * In practice, all secrets should be stored as a single JSON
   * payload on the `secrets` key. This ensures performant decryption. */
  ..._monitor_management.secretKeys]),
  attributesToIncludeInAAD
};