"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.journeyScreenshotBlocksHandler = exports.createJourneyScreenshotBlocksRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _Either = require("fp-ts/Either");
var t = _interopRequireWildcard(require("io-ts"));
var _get_journey_screenshot_blocks = require("../../queries/get_journey_screenshot_blocks");
var _constants = require("../../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createJourneyScreenshotBlocksRoute = () => ({
  method: 'POST',
  path: _constants.SYNTHETICS_API_URLS.JOURNEY_SCREENSHOT_BLOCKS,
  validate: {
    body: _configSchema.schema.object({
      hashes: _configSchema.schema.arrayOf(_configSchema.schema.string())
    })
  },
  writeAccess: false,
  handler: async routeProps => {
    return await journeyScreenshotBlocksHandler(routeProps);
  }
});
exports.createJourneyScreenshotBlocksRoute = createJourneyScreenshotBlocksRoute;
const journeyScreenshotBlocksHandler = async ({
  response,
  request,
  syntheticsEsClient
}) => {
  const {
    hashes: blockIds
  } = request.body;
  if (!isStringArray(blockIds)) return response.badRequest();
  const result = await (0, _get_journey_screenshot_blocks.getJourneyScreenshotBlocks)({
    blockIds,
    syntheticsEsClient
  });
  if (result.length === 0) {
    return response.notFound();
  }
  return response.ok({
    body: result
  });
};
exports.journeyScreenshotBlocksHandler = journeyScreenshotBlocksHandler;
function isStringArray(data) {
  return (0, _Either.isRight)(t.array(t.string).decode(data));
}