"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAllSyntheticsMonitorRoute = void 0;
var _saved_object_to_monitor = require("./formatters/saved_object_to_monitor");
var _constants = require("../../../common/constants");
var _common = require("../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAllSyntheticsMonitorRoute = () => ({
  method: 'GET',
  path: _constants.SYNTHETICS_API_URLS.SYNTHETICS_MONITORS,
  validate: {},
  validation: {
    request: {
      query: _common.QuerySchema
    }
  },
  handler: async routeContext => {
    var _queryParams$perPage, _queryParams$page, _totalCount$total;
    const {
      request,
      syntheticsMonitorClient,
      monitorConfigRepository
    } = routeContext;
    const totalCountQuery = async () => {
      if ((0, _common.isMonitorsQueryFiltered)(request.query)) {
        return monitorConfigRepository.find({
          perPage: 0,
          page: 1
        });
      }
    };
    const queryParams = routeContext.request.query;
    const {
      filtersStr
    } = await (0, _common.getMonitorFilters)(routeContext);
    const [queryResultSavedObjects, totalCount] = await Promise.all([monitorConfigRepository.find({
      perPage: (_queryParams$perPage = queryParams.perPage) !== null && _queryParams$perPage !== void 0 ? _queryParams$perPage : 50,
      page: (_queryParams$page = queryParams.page) !== null && _queryParams$page !== void 0 ? _queryParams$page : 1,
      sortField: (0, _common.parseMappingKey)(queryParams.sortField),
      sortOrder: queryParams.sortOrder,
      searchFields: _common.MONITOR_SEARCH_FIELDS,
      search: queryParams.query,
      filter: filtersStr,
      searchAfter: queryParams.searchAfter,
      ...(queryParams.showFromAllSpaces && {
        namespaces: ['*']
      })
    }), totalCountQuery()]);
    const absoluteTotal = (_totalCount$total = totalCount === null || totalCount === void 0 ? void 0 : totalCount.total) !== null && _totalCount$total !== void 0 ? _totalCount$total : queryResultSavedObjects.total;
    const {
      saved_objects: savedObjects,
      per_page: perPageT,
      ...rest
    } = queryResultSavedObjects;
    return {
      ...rest,
      monitors: savedObjects.map(monitor => {
        var _request$query, _monitor$namespaces, _monitor$namespaces2;
        const mon = (0, _saved_object_to_monitor.mapSavedObjectToMonitor)({
          monitor,
          internal: (_request$query = request.query) === null || _request$query === void 0 ? void 0 : _request$query.internal
        });
        return {
          ...mon,
          spaceId: (_monitor$namespaces = monitor.namespaces) === null || _monitor$namespaces === void 0 ? void 0 : _monitor$namespaces[0],
          spaces: (_monitor$namespaces2 = monitor.namespaces) !== null && _monitor$namespaces2 !== void 0 ? _monitor$namespaces2 : []
        };
      }),
      absoluteTotal,
      perPage: perPageT,
      syncErrors: syntheticsMonitorClient.syntheticsService.syncErrors
    };
  }
});
exports.getAllSyntheticsMonitorRoute = getAllSyntheticsMonitorRoute;