"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOverviewConfigsPerLocation = getOverviewConfigsPerLocation;
exports.getSyntheticsMonitorRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _server = require("@kbn/core/server");
var _alert_config = require("../../../common/runtime_types/monitor_management/alert_config");
var _runtime_types = require("../../../common/runtime_types");
var _constants = require("../../../common/constants");
var _service_errors = require("../synthetics_service/service_errors");
var _saved_object_to_monitor = require("./formatters/saved_object_to_monitor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSyntheticsMonitorRoute = () => ({
  method: 'GET',
  path: _constants.SYNTHETICS_API_URLS.GET_SYNTHETICS_MONITOR,
  validate: {},
  validation: {
    request: {
      params: _configSchema.schema.object({
        monitorId: _configSchema.schema.string({
          minLength: 1,
          maxLength: 1024
        })
      }),
      query: _configSchema.schema.object({
        internal: _configSchema.schema.maybe(_configSchema.schema.boolean({
          defaultValue: false
        }))
      })
    }
  },
  handler: async ({
    request,
    response,
    server: {
      coreStart
    },
    spaceId,
    monitorConfigRepository
  }) => {
    const {
      monitorId
    } = request.params;
    try {
      var _await$coreStart$capa;
      const {
        internal
      } = request.query;
      const canSave = (_await$coreStart$capa = (await (coreStart === null || coreStart === void 0 ? void 0 : coreStart.capabilities.resolveCapabilities(request, {
        capabilityPath: 'uptime.*'
      }))).uptime.save) !== null && _await$coreStart$capa !== void 0 ? _await$coreStart$capa : false;
      if (Boolean(canSave)) {
        // only user with write permissions can decrypt the monitor
        const monitor = await monitorConfigRepository.getDecrypted(monitorId, spaceId);
        return {
          ...(0, _saved_object_to_monitor.mapSavedObjectToMonitor)({
            monitor: monitor.normalizedMonitor,
            internal
          }),
          spaceId,
          spaces: monitor.decryptedMonitor.namespaces
        };
      } else {
        const monObj = await monitorConfigRepository.get(monitorId);
        return {
          ...(0, _saved_object_to_monitor.mapSavedObjectToMonitor)({
            monitor: monObj,
            internal
          }),
          spaceId,
          spaces: monObj.namespaces
        };
      }
    } catch (getErr) {
      if (_server.SavedObjectsErrorHelpers.isNotFoundError(getErr)) {
        return (0, _service_errors.getMonitorNotFoundResponse)(response, monitorId);
      }
      throw getErr;
    }
  }
});
exports.getSyntheticsMonitorRoute = getSyntheticsMonitorRoute;
function getOverviewConfigsPerLocation(attributes, queriedLocations) {
  const id = attributes[_runtime_types.ConfigKey.MONITOR_QUERY_ID];
  const configId = attributes[_runtime_types.ConfigKey.CONFIG_ID];

  /* for each location, add a config item */
  const locations = attributes[_runtime_types.ConfigKey.LOCATIONS];
  const queriedLocationsArray = queriedLocations && !Array.isArray(queriedLocations) ? [queriedLocations] : queriedLocations;

  /* exclude nob matching locations if location filter is present */
  const filteredLocations = queriedLocationsArray !== null && queriedLocationsArray !== void 0 && queriedLocationsArray.length ? locations.filter(loc => loc.label && queriedLocationsArray.includes(loc.label) || queriedLocationsArray.includes(loc.id)) : locations;
  return filteredLocations.map(location => ({
    id,
    configId,
    location,
    name: attributes[_runtime_types.ConfigKey.NAME],
    schedule: attributes[_runtime_types.ConfigKey.SCHEDULE].number,
    tags: attributes[_runtime_types.ConfigKey.TAGS],
    isEnabled: attributes[_runtime_types.ConfigKey.ENABLED],
    type: attributes[_runtime_types.ConfigKey.MONITOR_TYPE],
    projectId: attributes[_runtime_types.ConfigKey.PROJECT_ID],
    isStatusAlertEnabled: (0, _alert_config.isStatusEnabled)(attributes[_runtime_types.ConfigKey.ALERT_CONFIG])
  }));
}