"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.journeyScreenshotHandler = void 0;
var _get_journey_screenshot = require("./get_journey_screenshot");
var _runtime_types = require("../../common/runtime_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getSharedHeaders(stepName, totalSteps) {
  return {
    'cache-control': 'max-age=600',
    'caption-name': stepName,
    'max-steps': String(totalSteps)
  };
}
const journeyScreenshotHandler = async ({
  response,
  request,
  syntheticsEsClient
}) => {
  const {
    checkGroup,
    stepIndex
  } = request.params;
  const result = await (0, _get_journey_screenshot.getJourneyScreenshot)({
    syntheticsEsClient,
    checkGroup,
    stepIndex
  });
  if (result === null) {
    return response.notFound();
  }
  if ((0, _runtime_types.isRefResult)(result)) {
    return response.ok({
      body: {
        screenshotRef: result
      },
      headers: getSharedHeaders(result.synthetics.step.name, result.totalSteps)
    });
  }
  return response.custom({
    statusCode: 500,
    body: {
      message: 'Screenshot metadata is not in the expected format',
      screenshotRef: result
    }
  });
};
exports.journeyScreenshotHandler = journeyScreenshotHandler;