"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initTlsAlertType = void 0;
var _react = _interopRequireDefault(require("react"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _translations = require("../../../../../common/rules/synthetics/translations");
var _ui = require("../../../../../common/constants/ui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let validateFunc;
const {
  defaultActionMessage,
  defaultRecoveryMessage,
  description
} = _translations.TlsTranslations;
const TLSAlert = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./lazy_wrapper/tls_alert'))));
const initTlsAlertType = ({
  core,
  plugins
}) => ({
  id: _ruleDataUtils.SYNTHETICS_ALERT_RULE_TYPES.TLS,
  iconClass: 'uptimeApp',
  documentationUrl(docLinks) {
    return `${docLinks.links.observability.syntheticsAlerting}`;
  },
  ruleParamsExpression: params => /*#__PURE__*/_react.default.createElement(TLSAlert, {
    coreStart: core,
    plugins: plugins,
    ruleParams: params.ruleParams,
    setRuleParams: params.setRuleParams
  }),
  description,
  validate: ruleParams => {
    if (!validateFunc) {
      (async function loadValidate() {
        const {
          validateTLSAlertParams
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./lazy_wrapper/validate_tls_alert')));
        validateFunc = validateTLSAlertParams;
      })();
    }
    return validateFunc ? validateFunc(ruleParams) : {};
  },
  defaultActionMessage,
  defaultRecoveryMessage,
  requiresAppContext: false,
  format: ({
    fields
  }) => ({
    reason: fields[_ruleDataUtils.ALERT_REASON] || '',
    link: `/app/synthetics${_ui.CERTIFICATES_ROUTE}`
  })
});
exports.initTlsAlertType = initTlsAlertType;