"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createEsParams = createEsParams;
exports.useReduxEsSearch = void 0;
var _reactRedux = require("react-redux");
var _react = require("react");
var _elasticsearch = require("../state/elasticsearch");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useReduxEsSearch = (params, fnDeps, options) => {
  const {
    name,
    isRequestReady = true
  } = options !== null && options !== void 0 ? options : {};
  const dispatch = (0, _reactRedux.useDispatch)();
  const loadings = (0, _reactRedux.useSelector)(_elasticsearch.selectEsQueryLoading);
  const results = (0, _reactRedux.useSelector)(_elasticsearch.selectEsQueryResult);
  const errors = (0, _reactRedux.useSelector)(_elasticsearch.selectEsQueryError);
  (0, _react.useEffect)(() => {
    if (params.index && isRequestReady) {
      dispatch(_elasticsearch.executeEsQueryAction.get({
        params,
        name
      }));
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [dispatch, name, JSON.stringify(params), isRequestReady, ...fnDeps]);
  return (0, _react.useMemo)(() => {
    return {
      data: results[name],
      loading: loadings[name],
      error: errors[name]
    };
  }, [errors, loadings, name, results]);
};
exports.useReduxEsSearch = useReduxEsSearch;
function createEsParams(params) {
  return params;
}