"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMonitorDetailLocator = useMonitorDetailLocator;
var _react = require("react");
var _common = require("@kbn/observability-plugin/common");
var _public = require("@kbn/kibana-react-plugin/public");
var _use_edit_monitor_locator = require("./use_edit_monitor_locator");
var _use_kibana_space = require("../../../hooks/use_kibana_space");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useMonitorDetailLocator({
  configId,
  locationId,
  spaces
}) {
  var _useKibana$services, _useKibana$services$s;
  const {
    space
  } = (0, _use_kibana_space.useKibanaSpace)();
  const [monitorUrl, setMonitorUrl] = (0, _react.useState)(undefined);
  const locator = (_useKibana$services = (0, _public.useKibana)().services) === null || _useKibana$services === void 0 ? void 0 : (_useKibana$services$s = _useKibana$services.share) === null || _useKibana$services$s === void 0 ? void 0 : _useKibana$services$s.url.locators.get(_common.syntheticsMonitorDetailLocatorID);
  (0, _react.useEffect)(() => {
    async function generateUrl() {
      const url = await (locator === null || locator === void 0 ? void 0 : locator.getUrl({
        configId,
        locationId,
        ...(0, _use_edit_monitor_locator.getMonitorSpaceToAppend)(space, spaces)
      }));
      setMonitorUrl(url);
    }
    generateUrl();
  }, [locator, configId, locationId, spaces, space === null || space === void 0 ? void 0 : space.id, space]);
  return monitorUrl;
}