"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyntheticsSharedContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _common = require("@kbn/kibana-react-plugin/common");
var _reactRedux = require("react-redux");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _reactQuery = require("@tanstack/react-query");
var _synthetics_refresh_context = require("./synthetics_refresh_context");
var _synthetics_data_view_context = require("./synthetics_data_view_context");
var _state = require("../state");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getEmptyFunctionComponent = ({
  children
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
const SyntheticsSharedContext = ({
  reduxStore,
  coreStart,
  setupPlugins,
  startPlugins,
  children,
  darkMode,
  reload$
}) => {
  const queryClient = new _reactQuery.QueryClient();
  const spacesApi = startPlugins.spaces;
  const ContextWrapper = (0, _react.useMemo)(() => spacesApi ? spacesApi.ui.components.getSpacesContextProvider : getEmptyFunctionComponent, [spacesApi]);
  return /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      ...coreStart,
      ...setupPlugins,
      storage: _state.storage,
      data: startPlugins.data,
      inspector: startPlugins.inspector,
      triggersActionsUi: startPlugins.triggersActionsUi,
      observability: startPlugins.observability,
      observabilityShared: startPlugins.observabilityShared,
      observabilityAIAssistant: startPlugins.observabilityAIAssistant,
      exploratoryView: startPlugins.exploratoryView,
      cases: startPlugins.cases,
      spaces: startPlugins.spaces,
      fleet: startPlugins.fleet,
      share: startPlugins.share,
      unifiedSearch: startPlugins.unifiedSearch,
      embeddable: startPlugins.embeddable,
      slo: startPlugins.slo,
      serverless: startPlugins.serverless,
      charts: startPlugins.charts
    }
  }, /*#__PURE__*/_react.default.createElement(_common.EuiThemeProvider, {
    darkMode: darkMode
  }, /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: reduxStore !== null && reduxStore !== void 0 ? reduxStore : _state.store
  }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient
  }, /*#__PURE__*/_react.default.createElement(_synthetics_refresh_context.SyntheticsRefreshContextProvider, {
    reload$: reload$
  }, /*#__PURE__*/_react.default.createElement(_synthetics_data_view_context.SyntheticsDataViewContextProvider, {
    dataViews: startPlugins.dataViews
  }, /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: {
      application: coreStart.application
    },
    style: {
      height: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(ContextWrapper, null, children))))))));
};
exports.SyntheticsSharedContext = SyntheticsSharedContext;