"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaterfallChart = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _waterfall_context = require("./context/waterfall_context");
var _waterfall_search = require("./waterfall_header/waterfall_search");
var _waterfall_mime_legend = require("./waterfall_header/waterfall_mime_legend");
var _waterfall_timing_legend = require("./waterfall_header/waterfall_timing_legend");
var _waterfall_tick_axis = require("./waterfall_header/waterfall_tick_axis");
var _styles = require("./styles");
var _constants = require("./constants");
var _sidebar = require("./sidebar");
var _use_bar_charts = require("./use_bar_charts");
var _waterfall_bar_chart = require("./waterfall_bar_chart");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WaterfallChart = ({
  tickFormat,
  domain,
  barStyleAccessor,
  renderSidebarItem,
  renderFlyout
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    data,
    query,
    setQuery,
    sidebarItems,
    activeFilters,
    setActiveFilters,
    showOnlyHighlightedNetworkRequests,
    setOnlyHighlighted,
    showCustomMarks,
    setShowCustomMarks,
    totalNetworkRequests,
    highlightedNetworkRequests,
    fetchedNetworkRequests
  } = (0, _waterfall_context.useWaterfallContext)();
  const shouldRenderSidebar = !!(sidebarItems && renderSidebarItem);
  const chartsToDisplay = (0, _use_bar_charts.useBarCharts)({
    data
  });
  const cancelPagePadding = {
    marginLeft: `-${euiTheme.size.l}`,
    marginRight: `-${euiTheme.size.l}`
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      position: 'relative',
      ...cancelPagePadding
    }
  }, /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartStickyHeaderContainer, {
    "data-test-sub": "syntheticsWaterfallChartStickyHeaderContainer",
    style: {
      background: euiTheme.colors.body
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    style: {
      height: '100%'
    },
    gutterSize: "s",
    alignItems: "stretch",
    responsive: false
  }, shouldRenderSidebar && /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartSidebarWrapper, {
    grow: _constants.SIDEBAR_GROW_SIZE
  }, /*#__PURE__*/_react.default.createElement(_waterfall_search.WaterfallSearch, {
    query: query,
    setQuery: setQuery,
    totalNetworkRequests: totalNetworkRequests,
    highlightedNetworkRequests: highlightedNetworkRequests,
    fetchedNetworkRequests: fetchedNetworkRequests
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: shouldRenderSidebar ? _constants.MAIN_GROW_SIZE : true
  }, /*#__PURE__*/_react.default.createElement(_waterfall_mime_legend.WaterfallMimeLegend, {
    activeFilters: activeFilters,
    setActiveFilters: setActiveFilters,
    showCustomMarks: showCustomMarks,
    setShowCustomMarks: setShowCustomMarks
  }))), /*#__PURE__*/_react.default.createElement(_waterfall_tick_axis.WaterfallTickAxis, {
    showOnlyHighlightedNetworkRequests: showOnlyHighlightedNetworkRequests,
    setOnlyHighlighted: setOnlyHighlighted,
    highlightedNetworkRequests: highlightedNetworkRequests,
    fetchedNetworkRequests: fetchedNetworkRequests,
    shouldRenderSidebar: shouldRenderSidebar,
    domain: domain,
    tickFormat: tickFormat,
    barStyleAccessor: barStyleAccessor
  })), /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartOuterContainer, {
    "data-test-subj": "syntheticsWaterfallChartOuterContainer"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    responsive: false
  }, shouldRenderSidebar ? /*#__PURE__*/_react.default.createElement(_sidebar.Sidebar, {
    items: sidebarItems,
    render: renderSidebarItem
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      marginLeft: '-16px'
    },
    grow: shouldRenderSidebar ? _constants.MAIN_GROW_SIZE : true,
    "data-test-subj": "dataOnlyWrapper"
  }, chartsToDisplay.map((chartData, ind) => /*#__PURE__*/_react.default.createElement(_waterfall_bar_chart.WaterfallBarChart, {
    index: ind,
    key: ind,
    chartData: chartData,
    domain: domain,
    barStyleAccessor: barStyleAccessor,
    tickFormat: tickFormat
  }))))), /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartStickyFooterContainer, {
    "data-test-sub": "syntheticsWaterfallChartStickyFooterContainer",
    style: {
      background: euiTheme.colors.body
    }
  }, /*#__PURE__*/_react.default.createElement(_waterfall_timing_legend.WaterfallTimingLegend, null)), renderFlyout && renderFlyout());
};
exports.WaterfallChart = WaterfallChart;