"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaterfallTooltipResponsiveMaxWidth = exports.WaterfallChartTooltip = exports.WaterfallChartTimeTicksContainer = exports.WaterfallChartStickyHeaderContainer = exports.WaterfallChartStickyFooterContainer = exports.WaterfallChartSidebarWrapper = exports.WaterfallChartOuterContainer = exports.WaterfallChartFixedAxisContainer = exports.WaterfallChartChartContainer = exports.SideBarItemHighlighter = void 0;
var _eui = require("@elastic/eui");
var _polished = require("polished");
var _common = require("@kbn/kibana-react-plugin/common");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledScrollDiv = _common.euiStyled.div`
  &::-webkit-scrollbar {
    height: ${({
  theme
}) => theme.eui.euiScrollBar};
    width: ${({
  theme
}) => theme.eui.euiScrollBar};
  }
  &::-webkit-scrollbar-thumb {
    background-clip: content-box;
    background-color: ${({
  theme
}) => (0, _polished.rgba)(theme.eui.euiColorDarkShade, 0.5)};
    border: ${({
  theme
}) => theme.eui.euiScrollBarCorner} solid transparent;
  }
  &::-webkit-scrollbar-corner,
  &::-webkit-scrollbar-track {
    background-color: transparent;
  }
`;
const WaterfallChartOuterContainer = exports.WaterfallChartOuterContainer = (0, _common.euiStyled)(StyledScrollDiv)`
  height: auto;
  overflow: hidden;
  z-index: 50;
`;
const WaterfallChartStickyHeaderContainer = exports.WaterfallChartStickyHeaderContainer = (0, _common.euiStyled)(StyledScrollDiv)`
  position: sticky;
  top: 96px;
  z-index: ${props => props.theme.eui.euiZLevel5 + 10};
  overflow: visible;
  min-height: ${_constants.CHART_HEADER_HEIGHT}px;
  border-color: ${props => props.theme.eui.euiColorLightShade};
  border-top: ${props => props.theme.eui.euiBorderThin};
  border-bottom: ${props => props.theme.eui.euiBorderThin};
  padding: ${props => props.theme.eui.euiSizeL};
  padding-bottom: ${props => props.theme.eui.euiSizeXL};
  padding-left: ${props => props.theme.eui.euiSizeM};
`;
const WaterfallChartStickyFooterContainer = exports.WaterfallChartStickyFooterContainer = (0, _common.euiStyled)(StyledScrollDiv)`
  position: sticky;
  bottom: 0px;
  z-index: ${props => props.theme.eui.euiZLevel5};
  overflow: visible;
  border-color: ${props => props.theme.eui.euiColorLightShade};
  border-top: ${props => props.theme.eui.euiBorderThin};
  border-bottom: ${props => props.theme.eui.euiBorderThin};
  padding: ${props => props.theme.eui.euiSizeM};
`;
const WaterfallChartTimeTicksContainer = exports.WaterfallChartTimeTicksContainer = (0, _common.euiStyled)(StyledScrollDiv)`
  z-index: ${props => props.theme.eui.euiZLevel6};
  overflow: hidden;
  position: absolute;
  left: 0;
  bottom: -10px;
  width: 100%;
  height: auto;
  border: none;
  background: transparent;
`;
const WaterfallChartFixedAxisContainer = exports.WaterfallChartFixedAxisContainer = _common.euiStyled.div`
  z-index: ${props => props.theme.eui.euiZLevel4};
  height: 100%;
  &&& {
    .echAnnotation__icon {
      top: 8px;
    }
  }
`;
const WaterfallChartSidebarWrapper = exports.WaterfallChartSidebarWrapper = (0, _common.euiStyled)(_eui.EuiFlexItem)`
  z-index: ${props => props.theme.eui.euiZLevel4};
  min-width: 0;
`; // NOTE: min-width: 0 ensures flexbox and no-wrap children can co-exist

const SideBarItemHighlighter = exports.SideBarItemHighlighter = (0, _common.euiStyled)(_eui.EuiFlexItem)`
  height: 100%;
  .euiButtonEmpty {
    height: ${_constants.FIXED_AXIS_HEIGHT}px;
    font-size:${({
  theme
}) => theme.eui.euiFontSizeM};
  }
`;
const WaterfallChartChartContainer = exports.WaterfallChartChartContainer = _common.euiStyled.div`
  width: 100%;
  height: ${props => `${props.height + _constants.FIXED_AXIS_HEIGHT + 4}px`};
  margin-top: -${_constants.FIXED_AXIS_HEIGHT + 4}px;
  z-index: ${props => Math.round(props.theme.eui.euiZLevel3 / (props.chartIndex + 1))};
  background-color: ${props => props.theme.eui.euiColorEmptyShade};

  &&& {
    .echCanvasRenderer {
      height: calc(100% + 0px) !important;
      }
  }
`;
const WaterfallTooltipResponsiveMaxWidth = exports.WaterfallTooltipResponsiveMaxWidth = _common.euiStyled.div`
  max-width: 90vw;
`;
const WaterfallChartTooltip = exports.WaterfallChartTooltip = (0, _common.euiStyled)(WaterfallTooltipResponsiveMaxWidth)`
  background-color: ${({
  theme: {
    eui,
    darkMode
  }
}) => darkMode ? eui.euiColorDarkestShade : eui.euiColorEmptyShade};
  border-radius: ${props => props.theme.eui.euiBorderRadius};
  color: ${({
  theme: {
    eui,
    darkMode
  }
}) => !darkMode ? eui.euiColorDarkestShade : eui.euiColorLightestShade};
  padding: ${props => props.theme.eui.euiSizeS};
  .euiToolTip__arrow {
    background-color: ${({
  theme: {
    eui,
    darkMode
  }
}) => darkMode ? eui.euiColorDarkestShade : eui.euiColorEmptyShade};
  }
`;