"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LocationForm = exports.LOCATION_NAME_LABEL = exports.AGENT_MISSING_CALLOUT_TITLE = exports.AGENT_CALLOUT_TITLE = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _i18n = require("@kbn/i18n");
var _reactHookForm = require("react-hook-form");
var _agent_policies = require("../../../state/agent_policies");
var _browser_monitor_callout = require("./browser_monitor_callout");
var _spaces_select = require("../components/spaces_select");
var _tags_field = require("../components/tags_field");
var _agent_policy_needed = require("./agent_policy_needed");
var _policy_hosts = require("./policy_hosts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LocationForm = ({
  privateLocations,
  privateLocationToEdit
}) => {
  var _errors$label;
  const {
    data
  } = (0, _reactRedux.useSelector)(_agent_policies.selectAgentPolicies);
  const {
    control,
    register
  } = (0, _reactHookForm.useFormContext)();
  const {
    errors
  } = (0, _reactHookForm.useFormState)();
  const tagsList = privateLocations.reduce((acc, item) => {
    const tags = item.tags || [];
    return [...acc, ...tags];
  }, []);
  const isEditingLocation = privateLocationToEdit !== undefined;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (data === null || data === void 0 ? void 0 : data.length) === 0 && /*#__PURE__*/_react.default.createElement(_agent_policy_needed.AgentPolicyNeeded, null), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    noValidate: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: LOCATION_NAME_LABEL,
    isInvalid: Boolean(errors === null || errors === void 0 ? void 0 : errors.label),
    error: errors === null || errors === void 0 ? void 0 : (_errors$label = errors.label) === null || _errors$label === void 0 ? void 0 : _errors$label.message
  }, /*#__PURE__*/_react.default.createElement(FieldText, (0, _extends2.default)({
    "data-test-subj": "syntheticsLocationFormFieldText",
    fullWidth: true,
    "aria-label": LOCATION_NAME_LABEL
  }, register('label', {
    required: {
      value: true,
      message: NAME_REQUIRED
    },
    validate: val => {
      return privateLocations.some(loc => loc.label === val) && val !== (privateLocationToEdit === null || privateLocationToEdit === void 0 ? void 0 : privateLocationToEdit.label) ? NAME_ALREADY_EXISTS : undefined;
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_policy_hosts.PolicyHostsField, {
    privateLocations: privateLocations,
    isDisabled: isEditingLocation
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_tags_field.TagsField, {
    tagsList: tagsList,
    control: control,
    errors: errors
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_browser_monitor_callout.BrowserMonitorCallout, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_spaces_select.SpaceSelector, {
    helpText: LOCATION_HELP_TEXT,
    isDisabled: isEditingLocation
  })));
};
exports.LocationForm = LocationForm;
const FieldText = /*#__PURE__*/_react.default.forwardRef((props, ref) => /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
  "data-test-subj": "syntheticsFieldTextFieldText"
}, props, {
  inputRef: ref
})));
const AGENT_CALLOUT_TITLE = exports.AGENT_CALLOUT_TITLE = _i18n.i18n.translate('xpack.synthetics.monitorManagement.agentCallout.title', {
  defaultMessage: 'Requirement'
});
const AGENT_MISSING_CALLOUT_TITLE = exports.AGENT_MISSING_CALLOUT_TITLE = _i18n.i18n.translate('xpack.synthetics.monitorManagement.agentMissingCallout.title', {
  defaultMessage: 'Selected agent policy has no agents'
});
const LOCATION_NAME_LABEL = exports.LOCATION_NAME_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.locationName', {
  defaultMessage: 'Location name'
});
const LOCATION_HELP_TEXT = _i18n.i18n.translate('xpack.synthetics.privateLocation.locationSpacesHelpText', {
  defaultMessage: 'Select the spaces where this location will be available.'
});
const NAME_ALREADY_EXISTS = _i18n.i18n.translate('xpack.synthetics.monitorManagement.alreadyExists', {
  defaultMessage: 'Location name already exists.'
});
const NAME_REQUIRED = _i18n.i18n.translate('xpack.synthetics.monitorManagement.nameRequired', {
  defaultMessage: 'Location name is required'
});