"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverviewGrid = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _i18n = require("@kbn/i18n");
var _reactWindowInfiniteLoader = _interopRequireDefault(require("react-window-infinite-loader"));
var _reactWindow = require("react-window");
var _eui = require("@elastic/eui");
var _metric_item = require("./metric_item/metric_item");
var _show_all_spaces = require("../../common/show_all_spaces");
var _constants = require("../../../../../embeddables/constants");
var _add_to_dashboard = require("../../../common/components/add_to_dashboard");
var _use_overview_status = require("../../hooks/use_overview_status");
var _grid_items_by_group = require("./grid_by_group/grid_items_by_group");
var _group_fields = require("./grid_by_group/group_fields");
var _overview = require("../../../../state/overview");
var _use_monitors_sorted_by_status = require("../../../../hooks/use_monitors_sorted_by_status");
var _overview_loader = require("./overview_loader");
var _overview_pagination_info = require("./overview_pagination_info");
var _sort_fields = require("./sort_fields");
var _no_monitors_found = require("../../common/no_monitors_found");
var _contexts = require("../../../../contexts");
var _monitor_detail_flyout = require("./monitor_detail_flyout");
var _overview_grid_compact_view = require("./compact_view/overview_grid_compact_view");
var _view_buttons = require("./view_buttons/view_buttons");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ITEM_HEIGHT = _metric_item.METRIC_ITEM_HEIGHT + 12;
const MAX_LIST_HEIGHT = 800;
const MIN_BATCH_SIZE = 20;
const LIST_THRESHOLD = 12;
const MIN_CARD_WIDTH = 400;
const OverviewGrid = exports.OverviewGrid = /*#__PURE__*/(0, _react.memo)(({
  view,
  isEmbeddable
}) => {
  const {
    status,
    allConfigs,
    loaded
  } = (0, _use_overview_status.useOverviewStatus)({
    scopeStatusByLocation: true
  });
  const monitorsSortedByStatus = (0, _use_monitors_sorted_by_status.useMonitorsSortedByStatus)();
  const {
    pageState,
    groupBy: {
      field: groupField
    }
  } = (0, _reactRedux.useSelector)(_overview.selectOverviewState);
  const [rowCount, setRowCount] = (0, _react.useState)(5);
  const trendData = (0, _reactRedux.useSelector)(_overview.selectOverviewTrends);
  const {
    perPage
  } = pageState;
  const [maxItem, setMaxItem] = (0, _react.useState)(0);
  const [currentIndex, setCurrentIndex] = (0, _react.useState)(0);
  const dispatch = (0, _reactRedux.useDispatch)();
  const setFlyoutConfigCallback = (0, _react.useCallback)(params => dispatch((0, _overview.setFlyoutConfig)(params)), [dispatch]);
  const {
    lastRefresh
  } = (0, _contexts.useSyntheticsRefreshContext)();
  (0, _react.useEffect)(() => {
    const trendRequests = monitorsSortedByStatus.reduce((acc, item) => {
      if (trendData[item.configId + item.locationId] === undefined) {
        acc.push({
          configId: item.configId,
          locationId: item.locationId,
          schedule: item.schedule
        });
      }
      return acc;
    }, []);
    if (trendRequests.length) dispatch(_overview.trendStatsBatch.get(trendRequests));
  }, [dispatch, maxItem, monitorsSortedByStatus, trendData]);
  const listHeight = Math.min(ITEM_HEIGHT * Math.ceil(monitorsSortedByStatus.length / rowCount), MAX_LIST_HEIGHT);
  const listItems = (0, _react.useMemo)(() => {
    const acc = [];
    for (let i = 0; i < monitorsSortedByStatus.length; i += rowCount) {
      acc.push(monitorsSortedByStatus.slice(i, i + rowCount));
    }
    return acc;
  }, [monitorsSortedByStatus, rowCount]);
  const listRef = /*#__PURE__*/_react.default.createRef();
  (0, _react.useEffect)(() => {
    dispatch(_overview.refreshOverviewTrends.get());
  }, [dispatch, lastRefresh]);

  // Display no monitors found when down, up, or disabled filter produces no results
  if (status && !monitorsSortedByStatus.length && loaded) {
    return /*#__PURE__*/_react.default.createElement(_no_monitors_found.NoMonitorsFound, null);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    responsive: false,
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_overview_pagination_info.OverviewPaginationInfo, {
    total: status ? monitorsSortedByStatus.length : undefined
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_show_all_spaces.ShowAllSpaces, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_add_to_dashboard.AddToDashboard, {
    type: _constants.SYNTHETICS_MONITORS_EMBEDDABLE,
    asButton: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_sort_fields.SortFields, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_group_fields.GroupFields, null)), !isEmbeddable ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_view_buttons.ViewButtons, null)) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), view === 'cardView' ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    style: groupField === 'none' ? {
      height: listHeight
    } : undefined
  }, groupField === 'none' ? loaded && monitorsSortedByStatus.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiAutoSizer, null, ({
    width
  }) => /*#__PURE__*/_react.default.createElement(_reactWindowInfiniteLoader.default, {
    isItemLoaded: idx => listItems[idx].every(m => !!trendData[m.configId + m.locationId]),
    itemCount: listItems.length,
    loadMoreItems: (_, stop) => setMaxItem(Math.max(maxItem, stop)),
    minimumBatchSize: MIN_BATCH_SIZE,
    threshold: LIST_THRESHOLD
  }, ({
    onItemsRendered,
    ref
  }) => {
    // set min row count to based on width to ensure cards are not too small
    // min is 1 and max is 5
    setRowCount(Math.max(1, Math.min(5, Math.floor(width / MIN_CARD_WIDTH))));
    return /*#__PURE__*/_react.default.createElement(_reactWindow.FixedSizeList
    // pad computed height to avoid clipping last row's drop shadow
    , {
      height: listHeight + 16,
      width: width,
      onItemsRendered: onItemsRendered,
      itemSize: ITEM_HEIGHT,
      itemCount: listItems.length,
      itemData: listItems,
      ref: ref
    }, ({
      index: listIndex,
      style,
      data: listData
    }) => {
      setCurrentIndex(listIndex);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        "data-test-subj": `overview-grid-row-${listIndex}`,
        gutterSize: "m",
        css: {
          ...style,
          marginLeft: 5
        }
      }, listData[listIndex].map((_, idx) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        "data-test-subj": "syntheticsOverviewGridItem",
        key: listIndex * rowCount + idx
      }, /*#__PURE__*/_react.default.createElement(_metric_item.MetricItem, {
        monitor: monitorsSortedByStatus[listIndex * rowCount + idx],
        onClick: setFlyoutConfigCallback
      }))), listData[listIndex].length % rowCount !== 0 &&
      // Adds empty items to fill out row
      Array.from({
        length: rowCount - listData[listIndex].length
      }).map((_, idx) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: idx
      })));
    });
  })) : /*#__PURE__*/_react.default.createElement(_overview_loader.OverviewLoader, null) : /*#__PURE__*/_react.default.createElement(_grid_items_by_group.GridItemsByGroup, {
    setFlyoutConfigCallback: setFlyoutConfigCallback,
    view: view
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), groupField === 'none' && loaded &&
  // display this footer when user scrolls to end of list
  currentIndex * rowCount + rowCount >= monitorsSortedByStatus.length && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, monitorsSortedByStatus.length === allConfigs.length && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, SHOWING_ALL_MONITORS_LABEL)), monitorsSortedByStatus.length === allConfigs.length && monitorsSortedByStatus.length > perPage && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsOverviewGridButton",
    onClick: () => {
      var _listRef$current;
      window.scrollTo({
        top: 0,
        left: 0,
        behavior: 'smooth'
      });
      (_listRef$current = listRef.current) === null || _listRef$current === void 0 ? void 0 : _listRef$current.scrollToItem(0);
    },
    iconType: "sortUp",
    iconSide: "right",
    size: "xs"
  }, SCROLL_TO_TOP_LABEL))))) : null, view === 'compactView' ? /*#__PURE__*/_react.default.createElement(_overview_grid_compact_view.OverviewGridCompactView, {
    setFlyoutConfigCallback: setFlyoutConfigCallback
  }) : null, /*#__PURE__*/_react.default.createElement(_monitor_detail_flyout.MaybeMonitorDetailsFlyout, {
    setFlyoutConfigCallback: setFlyoutConfigCallback
  }));
});
const SHOWING_ALL_MONITORS_LABEL = _i18n.i18n.translate('xpack.synthetics.overview.grid.showingAllMonitors.label', {
  defaultMessage: 'Showing all monitors'
});
const SCROLL_TO_TOP_LABEL = _i18n.i18n.translate('xpack.synthetics.overview.grid.scrollToTop.label', {
  defaultMessage: 'Back to top'
});