"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.showSyncErrors = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const showSyncErrors = (errors, locations, core) => {
  const {
    notifications,
    ...startServices
  } = core;
  Object.values(errors).forEach(location => {
    var _locations$find;
    const {
      status: responseStatus,
      reason
    } = location.error || {};
    notifications.toasts.addWarning({
      title: _i18n.i18n.translate('xpack.synthetics.monitorManagement.service.error.title', {
        defaultMessage: `Unable to sync monitor config`
      }),
      text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.synthetics.monitorManagement.service.error.message', {
        defaultMessage: `Your monitor was saved, but there was a problem syncing the configuration for {location}. We will automatically try again later. If this problem continues, your monitors will stop running in {location}. Please contact Support for assistance.`,
        values: {
          location: locations === null || locations === void 0 ? void 0 : (_locations$find = locations.find(loc => (loc === null || loc === void 0 ? void 0 : loc.id) === location.locationId)) === null || _locations$find === void 0 ? void 0 : _locations$find.label
        }
      })), responseStatus || reason ? /*#__PURE__*/_react.default.createElement("p", null, responseStatus ? _i18n.i18n.translate('xpack.synthetics.monitorManagement.service.error.status', {
        defaultMessage: 'Status: {status}. ',
        values: {
          status: responseStatus
        }
      }) : null, reason ? _i18n.i18n.translate('xpack.synthetics.monitorManagement.service.error.reason', {
        defaultMessage: 'Reason: {reason}.',
        values: {
          reason
        }
      }) : null) : null), startServices),
      toastLifeTimeMs: 30000
    });
  });
};
exports.showSyncErrors = showSyncErrors;