"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMonitorQueryFilters = void 0;
var _react = require("react");
var _hooks = require("../../../hooks");
var _client_defaults = require("../../../../../../common/constants/client_defaults");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useMonitorQueryFilters = () => {
  const {
    query
  } = (0, _hooks.useGetUrlParams)();
  return (0, _react.useMemo)(() => {
    return query ? [(0, _client_defaults.getQueryFilters)(query)] : undefined;
  }, [query]);
};
exports.useMonitorQueryFilters = useMonitorQueryFilters;