"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMonitorList = useMonitorList;
var _react = require("react");
var _reactRedux = require("react-redux");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _use_filters = require("../common/monitor_filters/use_filters");
var _state = require("../../../state");
var _contexts = require("../../../contexts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useMonitorList() {
  var _data$total, _data$absoluteTotal;
  const dispatch = (0, _reactRedux.useDispatch)();
  const isInitialMount = (0, _react.useRef)(true);
  const {
    pageState,
    loading,
    loaded,
    error,
    data
  } = (0, _reactRedux.useSelector)(_state.selectMonitorListState);
  const syntheticsMonitors = (0, _reactRedux.useSelector)(_state.selectEncryptedSyntheticsSavedMonitors);
  const {
    handleFilterChange
  } = (0, _use_filters.useMonitorFiltersState)();
  const {
    lastRefresh
  } = (0, _contexts.useSyntheticsRefreshContext)();
  const loadPage = (0, _react.useCallback)(state => {
    dispatch((0, _state.updateManagementPageStateAction)(state));
  }, [dispatch]);
  const reloadPage = (0, _react.useCallback)(() => loadPage(pageState), [pageState, loadPage]);

  // Periodically refresh
  (0, _react.useEffect)(() => {
    if (!isInitialMount.current) {
      dispatch((0, _state.quietFetchMonitorListAction)({
        ...pageState
      }));
    }
    // specifically only want to run this on refreshInterval change
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [lastRefresh]);

  // On initial mount, load the page
  (0, _useDebounce.default)(() => {
    if (isInitialMount.current) {
      if (loaded) {
        dispatch((0, _state.quietFetchMonitorListAction)(pageState));
      } else {
        dispatch(_state.fetchMonitorListAction.get(pageState));
      }
    }
  }, 100,
  // we don't use pageState here, for pageState, useDebounce will handle it
  [dispatch]);
  (0, _useDebounce.default)(() => {
    // Don't load on initial mount, only meant to handle pageState changes
    if (isInitialMount.current || !loaded) {
      // setting false here to account for debounce timing
      isInitialMount.current = false;
      return;
    }
    dispatch(_state.fetchMonitorListAction.get(pageState));
  }, 200, [pageState]);
  return {
    loading,
    loaded,
    error,
    pageState,
    syntheticsMonitors,
    total: (_data$total = data === null || data === void 0 ? void 0 : data.total) !== null && _data$total !== void 0 ? _data$total : 0,
    loadPage,
    reloadPage,
    absoluteTotal: (_data$absoluteTotal = data.absoluteTotal) !== null && _data$absoluteTotal !== void 0 ? _data$absoluteTotal : 0,
    handleFilterChange
  };
}