"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShowAllSpaces = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _reactRedux = require("react-redux");
var _useSessionStorage = _interopRequireDefault(require("react-use/lib/useSessionStorage"));
var _overview_status = require("../../../state/overview_status");
var _state = require("../../../state");
var _use_kibana_space = require("../../../../../hooks/use_kibana_space");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ShowAllSpaces = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.synthetics.showAllSpaces.spacesTextLabel', {
    defaultMessage: 'Spaces'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(SelectablePopover, null)));
};
exports.ShowAllSpaces = ShowAllSpaces;
const SelectablePopover = () => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const {
    space
  } = (0, _use_kibana_space.useKibanaSpace)();
  const [showFromAllSpacesVal, setShowFromAllSpacesVal] = (0, _useSessionStorage.default)('SyntheticsShowFromAllSpaces', false);
  const dispatch = (0, _reactRedux.useDispatch)();
  (0, _react.useEffect)(() => {
    if (showFromAllSpacesVal !== undefined) {
      dispatch((0, _state.setOverviewPageStateAction)({
        showFromAllSpaces: showFromAllSpacesVal
      }));
      dispatch((0, _state.updateManagementPageStateAction)({
        showFromAllSpaces: showFromAllSpacesVal
      }));
    }
  }, [dispatch, showFromAllSpacesVal]);
  const {
    pageState: {
      showFromAllSpaces
    }
  } = (0, _reactRedux.useSelector)(_state.selectOverviewState);
  const updateState = val => {
    setShowFromAllSpacesVal(val);
    dispatch((0, _overview_status.clearOverviewStatusState)());
    dispatch((0, _state.setOverviewPageStateAction)({
      showFromAllSpaces: val
    }));
    dispatch((0, _state.updateManagementPageStateAction)({
      showFromAllSpaces: val
    }));
    setIsPopoverOpen(false);
  };
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsClickMeToLoadAContextMenuButton",
    iconType: "arrowDown",
    iconSide: "right",
    onClick: () => setIsPopoverOpen(!isPopoverOpen),
    size: "xs"
  }, showFromAllSpaces ? ALL_SPACES_LABEL : (space === null || space === void 0 ? void 0 : space.name) || (space === null || space === void 0 ? void 0 : space.id));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "contextMenuSpaces",
    button: button,
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: [{
      id: 0,
      title: SHOW_MONITORS_FROM,
      items: [{
        name: `${CURRENT_SPACE_LABEL} - ${(space === null || space === void 0 ? void 0 : space.name) || (space === null || space === void 0 ? void 0 : space.id)}`,
        onClick: () => {
          updateState(false);
        },
        icon: showFromAllSpaces ? 'empty' : 'check'
      }, {
        name: ALL_SPACES_LABEL,
        onClick: () => {
          updateState(true);
        },
        icon: showFromAllSpaces ? 'check' : 'empty'
      }]
    }]
  }));
};
const ALL_SPACES_LABEL = _i18n.i18n.translate('xpack.synthetics.showAllSpaces.allSpacesLabel', {
  defaultMessage: 'All permitted spaces'
});
const CURRENT_SPACE_LABEL = _i18n.i18n.translate('xpack.synthetics.showAllSpaces.currentSpaceLabel', {
  defaultMessage: 'Current space'
});
const SHOW_MONITORS_FROM = _i18n.i18n.translate('xpack.synthetics.showAllSpaces.showMonitorsFrom', {
  defaultMessage: 'Show monitors from'
});