"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorErrorsCount = exports.ERRORS_LABEL = void 0;
var _public = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _public2 = require("@kbn/exploratory-view-plugin/public");
var _i18n = require("@kbn/i18n");
var _use_monitor_query_filters = require("../hooks/use_monitor_query_filters");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorErrorsCount = ({
  from,
  to,
  id
}) => {
  const {
    exploratoryView: {
      ExploratoryViewEmbeddable
    }
  } = (0, _public.useKibana)().services;
  const {
    queryIdFilter,
    locationFilter
  } = (0, _use_monitor_query_filters.useMonitorQueryFilters)();
  const time = (0, _react.useMemo)(() => ({
    from,
    to
  }), [from, to]);
  if (!queryIdFilter) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(ExploratoryViewEmbeddable, {
    id: id,
    align: "left",
    customHeight: "70px",
    reportType: _public2.ReportTypes.SINGLE_METRIC,
    attributes: [{
      time,
      reportDefinitions: queryIdFilter,
      dataType: 'synthetics',
      selectedMetricField: 'monitor_errors',
      name: ERRORS_LABEL,
      filters: locationFilter
    }]
  });
};
exports.MonitorErrorsCount = MonitorErrorsCount;
const ERRORS_LABEL = exports.ERRORS_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorDetails.summary.errors', {
  defaultMessage: 'Errors'
});