"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorAlerts = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/exploratory-view-plugin/public");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _public3 = require("@kbn/kibana-react-plugin/public");
var _use_selected_location = require("../hooks/use_selected_location");
var _use_monitor_query_filters = require("../hooks/use_monitor_query_filters");
var _alert_actions = require("./alert_actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MONITOR_STATUS_RULE = {
  'kibana.alert.rule.category': ['Synthetics monitor status']
};
const MonitorAlerts = ({
  to,
  from,
  dateLabel
}) => {
  const {
    exploratoryView: {
      ExploratoryViewEmbeddable
    }
  } = (0, _public3.useKibana)().services;
  const theme = (0, _public2.useTheme)();
  const {
    queryIdFilter,
    locationFilter
  } = (0, _use_monitor_query_filters.useMonitorQueryFilters)();
  const selectedLocation = (0, _use_selected_location.useSelectedLocation)();
  if (!selectedLocation || !queryIdFilter) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, null);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    paddingSize: "m",
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m",
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, ALERTS_LABEL, " (", /*#__PURE__*/_react.default.createElement("div", {
    style: {
      display: 'inline-block'
    }
  }, /*#__PURE__*/_react.default.createElement(ExploratoryViewEmbeddable, {
    noLabel: true,
    fontSize: 16,
    lineHeight: 27,
    withActions: false,
    customHeight: '27px',
    reportType: "single-metric",
    attributes: [{
      dataType: 'alerts',
      time: {
        from,
        to
      },
      name: 'All',
      selectedMetricField: _public.RECORDS_FIELD,
      reportDefinitions: {
        ...MONITOR_STATUS_RULE,
        ...queryIdFilter
      },
      filters: locationFilter !== null && locationFilter !== void 0 ? locationFilter : []
    }]
  })), ")"))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, dateLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_alert_actions.AlertActions, {
    from: from,
    to: to
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      width: 80
    },
    grow: false
  }, /*#__PURE__*/_react.default.createElement(ExploratoryViewEmbeddable, {
    dataTestSubj: "monitorActiveAlertsCount",
    customHeight: '120px',
    reportType: "single-metric",
    attributes: [{
      dataType: 'alerts',
      time: {
        from,
        to
      },
      name: ACTIVE_LABEL,
      selectedMetricField: _public.RECORDS_FIELD,
      reportDefinitions: {
        ...MONITOR_STATUS_RULE,
        ...queryIdFilter
      },
      filters: [{
        field: 'kibana.alert.status',
        values: ['active']
      }, ...(locationFilter !== null && locationFilter !== void 0 ? locationFilter : [])]
    }]
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      minWidth: 80
    }
  }, /*#__PURE__*/_react.default.createElement(ExploratoryViewEmbeddable, {
    sparklineMode: true,
    customHeight: "100px",
    reportType: "kpi-over-time",
    attributes: [{
      seriesType: 'area',
      time: {
        from,
        to
      },
      reportDefinitions: {
        ...MONITOR_STATUS_RULE,
        ...queryIdFilter
      },
      dataType: 'alerts',
      selectedMetricField: _public.RECORDS_FIELD,
      name: ACTIVE_LABEL,
      filters: [{
        field: 'kibana.alert.status',
        values: ['active']
      }, ...(locationFilter !== null && locationFilter !== void 0 ? locationFilter : [])],
      color: theme.eui.euiColorVis7_behindText
    }]
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: 85,
      marginLeft: 40
    }
  }, /*#__PURE__*/_react.default.createElement(ExploratoryViewEmbeddable, {
    customHeight: '120px',
    reportType: "single-metric",
    attributes: [{
      dataType: 'alerts',
      time: {
        from,
        to
      },
      name: RECOVERED_LABEL,
      selectedMetricField: _public.RECORDS_FIELD,
      reportDefinitions: {
        ...MONITOR_STATUS_RULE,
        ...queryIdFilter
      },
      filters: [{
        field: 'kibana.alert.status',
        values: ['recovered']
      }, ...(locationFilter !== null && locationFilter !== void 0 ? locationFilter : [])]
    }]
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      minWidth: 80
    }
  }, /*#__PURE__*/_react.default.createElement(ExploratoryViewEmbeddable, {
    sparklineMode: true,
    customHeight: "100px",
    reportType: "kpi-over-time",
    attributes: [{
      seriesType: 'area',
      time: {
        from,
        to
      },
      reportDefinitions: {
        ...MONITOR_STATUS_RULE,
        ...queryIdFilter
      },
      dataType: 'alerts',
      selectedMetricField: 'recovered_alerts',
      name: RECOVERED_LABEL,
      filters: [{
        field: 'kibana.alert.status',
        values: ['recovered']
      }, ...(locationFilter !== null && locationFilter !== void 0 ? locationFilter : [])],
      color: theme.eui.euiColorVis0_behindText
    }]
  }))));
};
exports.MonitorAlerts = MonitorAlerts;
const ALERTS_LABEL = _i18n.i18n.translate('xpack.synthetics.detailsPanel.alerts', {
  defaultMessage: 'Alerts'
});
const ACTIVE_LABEL = _i18n.i18n.translate('xpack.synthetics.detailsPanel.alerts.active', {
  defaultMessage: 'Active'
});
const RECOVERED_LABEL = _i18n.i18n.translate('xpack.synthetics.detailsPanel.alerts.recovered', {
  defaultMessage: 'Recovered'
});