"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MONITOR_ALERTS_TABLE_ID = void 0;
exports.MonitorDetailsAlerts = MonitorDetailsAlerts;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/observability-plugin/public");
var _hooks = require("../../../hooks");
var _synthetics_date_picker = require("../../common/date_picker/synthetics_date_picker");
var _use_selected_location = require("../hooks/use_selected_location");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MONITOR_ALERTS_TABLE_ID = exports.MONITOR_ALERTS_TABLE_ID = 'xpack.observability.slo.sloDetails.alertTable';
function MonitorDetailsAlerts() {
  const {
    monitorId: configId
  } = (0, _reactRouterDom.useParams)();
  const selectedLocation = (0, _use_selected_location.useSelectedLocation)();
  const {
    from,
    to
  } = (0, _hooks.useRefreshedRangeFromUrl)();
  if (!selectedLocation) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xl"
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xl"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_synthetics_date_picker.SyntheticsDatePicker, {
    fullWidth: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_public.ObservabilityAlertsTable, {
    id: MONITOR_ALERTS_TABLE_ID,
    ruleTypeIds: _ruleDataUtils.SYNTHETICS_RULE_TYPE_IDS,
    consumers: [_ruleDataUtils.AlertConsumers.UPTIME, _ruleDataUtils.AlertConsumers.ALERTS, _ruleDataUtils.AlertConsumers.OBSERVABILITY],
    query: {
      bool: {
        filter: [{
          term: {
            configId
          }
        }, {
          term: {
            'location.id': selectedLocation === null || selectedLocation === void 0 ? void 0 : selectedLocation.id
          }
        }, {
          range: {
            '@timestamp': {
              gte: from,
              lte: to
            }
          }
        }]
      }
    },
    initialPageSize: 100,
    "data-test-subj": "monitorAlertsTable",
    renderActionsCell: _public.AlertActions,
    showInspectButton: true
  }))));
}