"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMonitorQueryFilters = void 0;
var _react = require("react");
var _use_monitor_query_id = require("./use_monitor_query_id");
var _use_selected_location = require("./use_selected_location");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useMonitorQueryFilters = () => {
  const selectedLocation = (0, _use_selected_location.useSelectedLocation)();
  const monitorQueryId = (0, _use_monitor_query_id.useMonitorQueryId)();
  return (0, _react.useMemo)(() => {
    if (!monitorQueryId || !selectedLocation) {
      return {};
    }
    return {
      queryIdFilter: {
        'monitor.id': [monitorQueryId]
      },
      locationFilter: [{
        field: 'observer.geo.name',
        // in 8.6.0, observer.geo.name was mapped to the id,
        // so we have to pass both values to maintain history
        values: [selectedLocation.label, selectedLocation.id]
      }]
    };
  }, [monitorQueryId, selectedLocation]);
};
exports.useMonitorQueryFilters = useMonitorQueryFilters;