"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFailedTestByStep = useFailedTestByStep;
var _reactRouterDom = require("react-router-dom");
var _react = require("react");
var _use_redux_es_search = require("../../../hooks/use_redux_es_search");
var _use_selected_location = require("./use_selected_location");
var _es_search = require("../../../../../../common/utils/es_search");
var _data_filters = require("../../../../../../common/constants/data_filters");
var _constants = require("../../../../../../common/constants");
var _contexts = require("../../../contexts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFailedTestByStep({
  to,
  from
}) {
  const {
    lastRefresh
  } = (0, _contexts.useSyntheticsRefreshContext)();
  const {
    monitorId
  } = (0, _reactRouterDom.useParams)();
  const selectedLocation = (0, _use_selected_location.useSelectedLocation)();
  const params = (0, _es_search.createEsQuery)({
    index: _constants.SYNTHETICS_INDEX_PATTERN,
    body: {
      size: 0,
      track_total_hits: true,
      query: {
        bool: {
          filter: [{
            range: {
              '@timestamp': {
                lte: to,
                gte: from
              }
            }
          }, _data_filters.STEP_END_FILTER, {
            term: {
              'synthetics.step.status': 'failed'
            }
          }, {
            term: {
              'observer.geo.name': selectedLocation === null || selectedLocation === void 0 ? void 0 : selectedLocation.label
            }
          }, {
            term: {
              config_id: monitorId
            }
          }]
        }
      },
      aggs: {
        steps: {
          terms: {
            field: 'synthetics.step.name.keyword',
            size: 1000
          },
          aggs: {
            doc: {
              top_hits: {
                size: 1
              }
            }
          }
        }
      }
    }
  });
  const {
    data,
    loading
  } = (0, _use_redux_es_search.useReduxEsSearch)(params, [lastRefresh, monitorId], {
    name: `getFailedTestsByStep/${monitorId}`,
    isRequestReady: !!selectedLocation
  });
  return (0, _react.useMemo)(() => {
    var _data$aggregations;
    const total = data === null || data === void 0 ? void 0 : data.hits.total.value;
    const failedSteps = data === null || data === void 0 ? void 0 : (_data$aggregations = data.aggregations) === null || _data$aggregations === void 0 ? void 0 : _data$aggregations.steps.buckets.map(({
      key,
      doc_count: count,
      doc
    }) => {
      var _doc$hits$hits, _doc$hits$hits$0$_sou, _doc$hits$hits$0$_sou2, _doc$hits$hits$0$_sou3;
      const index = (_doc$hits$hits = doc.hits.hits) === null || _doc$hits$hits === void 0 ? void 0 : (_doc$hits$hits$0$_sou = _doc$hits$hits[0]._source) === null || _doc$hits$hits$0$_sou === void 0 ? void 0 : (_doc$hits$hits$0$_sou2 = _doc$hits$hits$0$_sou.synthetics) === null || _doc$hits$hits$0$_sou2 === void 0 ? void 0 : (_doc$hits$hits$0$_sou3 = _doc$hits$hits$0$_sou2.step) === null || _doc$hits$hits$0$_sou3 === void 0 ? void 0 : _doc$hits$hits$0$_sou3.index;
      return {
        index,
        count,
        name: key,
        // @ts-expect-error upgrade typescript v5.4.5
        percent: count / total * 100
      };
    });
    return {
      failedSteps,
      loading
    };
  }, [data, loading]);
}