"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorDetailsLinkPortal = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _reactReversePortal = require("react-reverse-portal");
var _use_selected_location = require("../monitor_details/hooks/use_selected_location");
var _portals = require("./portals");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorDetailsLinkPortal = ({
  name,
  configId,
  locationId,
  updateUrl
}) => {
  return /*#__PURE__*/_react.default.createElement(_reactReversePortal.InPortal, {
    node: _portals.MonitorDetailsLinkPortalNode
  }, locationId ? /*#__PURE__*/_react.default.createElement(MonitorDetailsLinkWithLocation, {
    name: name,
    configId: configId,
    locationId: locationId,
    updateUrl: updateUrl
  }) : /*#__PURE__*/_react.default.createElement(MonitorDetailsLink, {
    name: name,
    configId: configId
  }));
};
exports.MonitorDetailsLinkPortal = MonitorDetailsLinkPortal;
const MonitorDetailsLinkWithLocation = ({
  name,
  configId,
  locationId,
  updateUrl
}) => {
  const selectedLocation = (0, _use_selected_location.useSelectedLocation)({
    updateUrl
  });
  let locId = locationId;
  if (selectedLocation !== null && selectedLocation !== void 0 && selectedLocation.id && !locationId) {
    locId = selectedLocation.id;
  }
  const history = (0, _reactRouterDom.useHistory)();
  const href = history.createHref({
    pathname: locId ? `monitor/${configId}?locationId=${locId}` : `monitor/${configId}`
  });
  return /*#__PURE__*/_react.default.createElement(MonitorLink, {
    href: href,
    name: name
  });
};
const MonitorDetailsLink = ({
  name,
  configId
}) => {
  const history = (0, _reactRouterDom.useHistory)();
  const href = history.createHref({
    pathname: `monitor/${configId}`
  });
  return /*#__PURE__*/_react.default.createElement(MonitorLink, {
    href: href,
    name: name
  });
};
const MonitorLink = ({
  href,
  name
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "syntheticsMonitorDetailsLinkLink",
    href: href
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "arrowLeft"
  }), " ", name);
};