"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MaintenanceWindowsField = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_maintenance_windows = require("./use_maintenance_windows");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MaintenanceWindowsField = ({
  value,
  readOnly,
  onChange,
  fullWidth
}) => {
  var _data$data$map, _data$data;
  const {
    data
  } = (0, _use_maintenance_windows.useMaintenanceWindows)();
  const options = (_data$data$map = data === null || data === void 0 ? void 0 : (_data$data = data.data) === null || _data$data === void 0 ? void 0 : _data$data.map(option => ({
    value: option.id,
    label: option.title
  }))) !== null && _data$data$map !== void 0 ? _data$data$map : [];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    placeholder: _i18n.i18n.translate('xpack.synthetics.monitorConfig.maintenanceWindows.placeholder', {
      defaultMessage: 'Select maintenance windows'
    }),
    options: options,
    onChange: newValue => {
      onChange(newValue.map(option => option.value));
    },
    defaultValue: [],
    selectedOptions: options.filter(option => value === null || value === void 0 ? void 0 : value.includes(option.value)),
    fullWidth: fullWidth,
    isDisabled: readOnly
  });
};
exports.MaintenanceWindowsField = MaintenanceWindowsField;