"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsLink = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _alert_actions = require("../../monitor_details/monitor_summary/alert_actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertsLink = () => {
  const alertUrl = (0, _alert_actions.useAlertsUrl)({
    rangeFrom: 'now-12h/h',
    rangeTo: 'now'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: VIEW_ALERTS
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "syntheticsAlertsLinkButton",
    "aria-label": VIEW_ALERTS,
    href: alertUrl,
    iconType: "inspect"
  }));
};
exports.AlertsLink = AlertsLink;
const VIEW_ALERTS = _i18n.i18n.translate('xpack.synthetics.monitorSummary.viewAlerts', {
  defaultMessage: 'View alerts'
});