"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSyntheticsUiActions = void 0;
var _src = require("@kbn/ui-actions-browser/src");
var _constants = require("./constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const registerSyntheticsUiActions = async (coreStart, pluginsStart) => {
  const {
    uiActions,
    cloud,
    serverless
  } = pluginsStart;

  // Assign triggers
  // Only register these actions in stateful kibana, and the serverless observability project
  if (Boolean(serverless && (cloud === null || cloud === void 0 ? void 0 : cloud.serverless.projectType) === 'observability' || !serverless)) {
    uiActions.addTriggerActionAsync(_src.ADD_PANEL_TRIGGER, _constants.ADD_SYNTHETICS_OVERVIEW_ACTION_ID, async () => {
      const {
        createStatusOverviewPanelAction
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./add_panel_actions_module')));
      return createStatusOverviewPanelAction(coreStart, pluginsStart);
    });
    uiActions.addTriggerActionAsync(_src.ADD_PANEL_TRIGGER, _constants.ADD_SYNTHETICS_MONITORS_OVERVIEW_ACTION_ID, async () => {
      const {
        createMonitorsOverviewPanelAction
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./add_panel_actions_module')));
      return createMonitorsOverviewPanelAction(coreStart, pluginsStart);
    });
  }
};
exports.registerSyntheticsUiActions = registerSyntheticsUiActions;