"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.internalDashboardRoutes = void 0;
var _zod = require("@kbn/zod");
var _constants = require("../../../../common/constants");
var _create_server_route = require("../../create_server_route");
var _fields = require("../../../lib/streams/assets/fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function sanitizeDashboardAsset(asset) {
  return {
    id: asset[_fields.ASSET_ID],
    title: asset.title,
    tags: asset.tags
  };
}
const suggestDashboardsRoute = (0, _create_server_route.createServerRoute)({
  endpoint: 'POST /internal/streams/{name}/dashboards/_suggestions',
  options: {
    access: 'internal'
  },
  security: {
    authz: {
      requiredPrivileges: [_constants.STREAMS_API_PRIVILEGES.manage]
    }
  },
  params: _zod.z.object({
    path: _zod.z.object({
      name: _zod.z.string()
    }),
    query: _zod.z.object({
      query: _zod.z.string()
    }),
    body: _zod.z.object({
      tags: _zod.z.optional(_zod.z.array(_zod.z.string()))
    })
  }),
  handler: async ({
    params,
    request,
    getScopedClients
  }) => {
    const {
      assetClient,
      streamsClient
    } = await getScopedClients({
      request
    });
    await streamsClient.ensureStream(params.path.name);
    const {
      query: {
        query
      },
      body: {
        tags
      }
    } = params;
    const suggestions = (await assetClient.getSuggestions({
      assetTypes: ['dashboard'],
      query,
      tags
    })).assets.map(asset => {
      return sanitizeDashboardAsset(asset);
    });
    return {
      suggestions
    };
  }
});
const internalDashboardRoutes = exports.internalDashboardRoutes = {
  ...suggestDashboardsRoute
};