"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.config = exports.StreamsPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _server = require("@kbn/core/server");
var _common = require("@kbn/features-plugin/common");
var _i18n = require("@kbn/i18n");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _serverRouteRepository = require("@kbn/server-route-repository");
var _config = require("../common/config");
var _constants = require("../common/constants");
var _content_service = require("./lib/content/content_service");
var _register_rules = require("./lib/rules/register_rules");
var _asset_service = require("./lib/streams/assets/asset_service");
var _query_service = require("./lib/streams/assets/query/query_service");
var _service = require("./lib/streams/service");
var _service2 = require("./lib/telemetry/service");
var _routes = require("./routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line @typescript-eslint/no-empty-interface

// eslint-disable-next-line @typescript-eslint/no-empty-interface

const config = exports.config = {
  schema: _config.configSchema,
  exposeToBrowser: _config.exposeToBrowserConfig
};
class StreamsPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "server", void 0);
    (0, _defineProperty2.default)(this, "isDev", void 0);
    (0, _defineProperty2.default)(this, "telemetryService", new _service2.StreamsTelemetryService());
    this.isDev = context.env.mode.dev;
    this.config = context.config.get();
    this.logger = context.logger.get();
  }
  setup(core, plugins) {
    this.server = {
      config: this.config,
      logger: this.logger
    };
    this.telemetryService.setup(core.analytics);
    const alertingFeatures = _ruleDataUtils.STREAMS_RULE_TYPE_IDS.map(ruleTypeId => ({
      ruleTypeId,
      consumers: [_constants.STREAMS_CONSUMER]
    }));
    (0, _register_rules.registerRules)({
      plugins,
      logger: this.logger.get('rules')
    });
    const assetService = new _asset_service.AssetService(core, this.logger);
    const streamsService = new _service.StreamsService(core, this.logger, this.isDev);
    const contentService = new _content_service.ContentService(core, this.logger);
    const queryService = new _query_service.QueryService(core, this.logger);
    plugins.features.registerKibanaFeature({
      id: _constants.STREAMS_FEATURE_ID,
      name: _i18n.i18n.translate('xpack.streams.featureRegistry.streamsFeatureName', {
        defaultMessage: 'Streams'
      }),
      order: 600,
      category: _server.DEFAULT_APP_CATEGORIES.observability,
      scope: [_common.KibanaFeatureScope.Spaces, _common.KibanaFeatureScope.Security],
      app: [_constants.STREAMS_FEATURE_ID],
      privilegesTooltip: _i18n.i18n.translate('xpack.streams.featureRegistry.privilegesTooltip', {
        defaultMessage: 'All Spaces is required for Streams access.'
      }),
      alerting: alertingFeatures,
      privileges: {
        all: {
          app: [_constants.STREAMS_FEATURE_ID],
          savedObject: {
            all: [],
            read: []
          },
          requireAllSpaces: true,
          alerting: {
            rule: {
              all: alertingFeatures
            },
            alert: {
              all: alertingFeatures
            }
          },
          api: [_constants.STREAMS_API_PRIVILEGES.read, _constants.STREAMS_API_PRIVILEGES.manage],
          ui: [_constants.STREAMS_UI_PRIVILEGES.show, _constants.STREAMS_UI_PRIVILEGES.manage]
        },
        read: {
          app: [_constants.STREAMS_FEATURE_ID],
          savedObject: {
            all: [],
            read: []
          },
          requireAllSpaces: true,
          alerting: {
            rule: {
              read: alertingFeatures
            },
            alert: {
              read: alertingFeatures
            }
          },
          api: [_constants.STREAMS_API_PRIVILEGES.read],
          ui: [_constants.STREAMS_UI_PRIVILEGES.show]
        }
      }
    });
    core.pricing.registerProductFeatures(_constants.STREAMS_TIERED_FEATURES);
    (0, _serverRouteRepository.registerRoutes)({
      repository: _routes.streamsRouteRepository,
      dependencies: {
        assets: assetService,
        server: this.server,
        telemetry: this.telemetryService.getClient(),
        getScopedClients: async ({
          request
        }) => {
          const [[coreStart, pluginsStart], assetClient, contentClient] = await Promise.all([core.getStartServices(), assetService.getClientWithRequest({
            request
          }), contentService.getClient()]);
          const queryClient = await queryService.getClientWithRequest({
            request,
            assetClient
          });
          const streamsClient = await streamsService.getClientWithRequest({
            request,
            assetClient,
            queryClient
          });
          const scopedClusterClient = coreStart.elasticsearch.client.asScoped(request);
          const soClient = coreStart.savedObjects.getScopedClient(request);
          const inferenceClient = pluginsStart.inference.getClient({
            request
          });
          const licensing = pluginsStart.licensing;
          return {
            scopedClusterClient,
            soClient,
            assetClient,
            streamsClient,
            inferenceClient,
            contentClient,
            queryClient,
            licensing
          };
        }
      },
      core,
      logger: this.logger
    });
    return {};
  }
  start(core, plugins) {
    if (this.server) {
      this.server.core = core;
      this.server.isServerless = core.elasticsearch.getCapabilities().serverless;
      this.server.security = plugins.security;
      this.server.encryptedSavedObjects = plugins.encryptedSavedObjects;
      this.server.taskManager = plugins.taskManager;
    }
    return {};
  }
  stop() {}
}
exports.StreamsPlugin = StreamsPlugin;