"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryService = void 0;
var _fake_request_factory = require("../../helpers/fake_request_factory");
var _query_client = require("./query_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class QueryService {
  constructor(coreSetup, logger) {
    this.coreSetup = coreSetup;
    this.logger = logger;
  }
  async getClientWithRequest({
    request,
    assetClient
  }) {
    const [_, pluginStart] = await this.coreSetup.getStartServices();
    const fakeRequest = (0, _fake_request_factory.createFakeRequestBoundToDefaultSpace)(request);
    const rulesClient = await pluginStart.alerting.getRulesClientWithRequest(fakeRequest);
    return new _query_client.QueryClient({
      assetClient,
      rulesClient,
      logger: this.logger
    }, true);
  }
}
exports.QueryService = QueryService;