"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getKqlAsCommandArg = void 0;
exports.getRuleIdFromQueryLink = getRuleIdFromQueryLink;
var _objectHash = _interopRequireDefault(require("object-hash"));
var _uuid = require("uuid");
var _fields = require("../../fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getRuleIdFromQueryLink(query) {
  const queryHash = (0, _objectHash.default)([query[_fields.ASSET_UUID], query.query.kql.query]);
  return (0, _uuid.v5)(queryHash, _uuid.v5.DNS);
}
const getKqlAsCommandArg = str => {
  return str.replace(/(?<!\\)"/g, '\\"');
};
exports.getKqlAsCommandArg = getKqlAsCommandArg;