"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.esqlRuleType = esqlRuleType;
var _alertsAsDataUtils = require("@kbn/alerts-as-data-utils");
var _server = require("@kbn/core/server");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _constants = require("../../../../common/constants");
var _executor = require("./executor");
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function esqlRuleType() {
  return {
    id: _ruleDataUtils.STREAMS_ESQL_RULE_TYPE_ID,
    name: 'ES|QL Rule',
    validate: {
      params: {
        validate: object => {
          return _types.esqlRuleParams.parse(object);
        }
      }
    },
    schemas: {
      params: {
        type: 'zod',
        schema: _types.esqlRuleParams
      }
    },
    defaultActionGroupId: 'default',
    actionGroups: [{
      id: 'default',
      name: 'Default'
    }],
    minimumLicenseRequired: 'enterprise',
    category: _server.DEFAULT_APP_CATEGORIES.observability.id,
    producer: _constants.STREAMS_PRODUCER,
    solution: 'observability',
    isExportable: false,
    actionVariables: {},
    executor: _executor.getRuleExecutor,
    autoRecoverAlerts: false,
    alerts: {
      context: _constants.STREAMS_RULE_REGISTRATION_CONTEXT,
      mappings: {
        dynamic: false,
        fieldMap: {
          ..._alertsAsDataUtils.alertFieldMap
        }
      },
      shouldWrite: false,
      isSpaceAware: false
    },
    internallyManaged: true
  };
}