"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamDetailContextProvider = StreamDetailContextProvider;
exports.useStreamDetail = useStreamDetail;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _streamsSchema = require("@kbn/streams-schema");
var _public = require("@kbn/streams-plugin/public");
var _use_streams_app_fetch = require("./use_streams_app_fetch");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StreamDetailContext = /*#__PURE__*/_react.default.createContext(undefined);
function StreamDetailContextProvider({
  name,
  streamsRepositoryClient,
  children
}) {
  const {
    core: {
      application: {
        capabilities: {
          streams: {
            [_public.STREAMS_UI_PRIVILEGES.manage]: canManage
          }
        }
      }
    }
  } = (0, _use_kibana.useKibana)();
  const {
    value: definition,
    loading,
    refresh
  } = (0, _use_streams_app_fetch.useStreamsAppFetch)(async ({
    signal
  }) => {
    return streamsRepositoryClient.fetch('GET /api/streams/{name} 2023-10-31', {
      signal,
      params: {
        path: {
          name
        }
      }
    }).then(response => {
      if (_streamsSchema.Streams.ingest.all.GetResponse.is(response)) {
        return {
          ...response,
          privileges: {
            ...response.privileges,
            // restrict the manage privilege by the Elasticsearch-level data-stream specific privilege and the Kibana-level UI privilege
            // the UI should only enable manage features if the user has privileges on both levels for the current stream
            manage: response.privileges.manage && canManage
          }
        };
      }
      throw new Error('Stream detail only supports IngestStreams.');
    });
  }, [streamsRepositoryClient, name, canManage]);
  const context = _react.default.useMemo(
  // useMemo cannot be used conditionally after the definition narrowing, the assertion is to narrow correctly the context value
  () => ({
    definition,
    loading,
    refresh
  }), [definition, loading, refresh]);

  // Display loading spinner for first data-fetching only to have SWR-like behaviour
  if (!definition && loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xxl"
    }));
  }
  if (!definition) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(StreamDetailContext.Provider, {
    value: context
  }, children);
}
function useStreamDetail() {
  const ctx = _react.default.useContext(StreamDetailContext);
  if (!ctx) {
    throw new Error('useStreamDetail must be used within a StreamDetailContextProvider');
  }
  return ctx;
}