"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentsColumn = DocumentsColumn;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _charts = require("@elastic/charts");
var _chartsTheme = require("@kbn/charts-theme");
var _i18n = require("@kbn/i18n");
var _use_streams_app_fetch = require("../../hooks/use_streams_app_fetch");
var _use_kibana = require("../../hooks/use_kibana");
var _esql_result_to_timeseries = require("../../util/esql_result_to_timeseries");
var _use_timefilter = require("../../hooks/use_timefilter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DocumentsColumn({
  indexPattern,
  numDataPoints
}) {
  const {
    dependencies: {
      start: {
        streams: {
          streamsRepositoryClient
        }
      }
    }
  } = (0, _use_kibana.useKibana)();
  const chartBaseTheme = (0, _chartsTheme.useElasticChartsTheme)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const LoadingPlaceholder = _react.default.useCallback(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexEnd",
    gutterSize: "m",
    className: (0, _css.css)`
          height: ${euiTheme.size.xl};
          white-space: nowrap;
          padding-right: ${euiTheme.size.xl};
        `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: (0, _css.css)`
              text-align: center;
            `
  }, "-"), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: (0, _css.css)`
              display: flex;
              padding-right: ${euiTheme.size.xl};
              justify-content: center;
            `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    size: "m"
  })))), [euiTheme]);
  const {
    timeState
  } = (0, _use_timefilter.useTimefilter)();
  const minInterval = Math.floor((timeState.end - timeState.start) / numDataPoints);
  const histogramQueryFetch = (0, _use_streams_app_fetch.useStreamsAppFetch)(async ({
    signal,
    timeState: {
      start,
      end
    }
  }) => {
    return streamsRepositoryClient.fetch('POST /internal/streams/esql', {
      params: {
        body: {
          operationName: 'get_doc_count_for_stream',
          query: `FROM ${indexPattern} | STATS doc_count = COUNT(*) BY @timestamp = BUCKET(@timestamp, ${minInterval} ms)`,
          start,
          end
        }
      },
      signal
    });
  }, [streamsRepositoryClient, indexPattern, minInterval], {
    withTimeRange: true
  });
  const allTimeseries = _react.default.useMemo(() => (0, _esql_result_to_timeseries.esqlResultToTimeseries)({
    result: histogramQueryFetch,
    metricNames: ['doc_count']
  }), [histogramQueryFetch]);
  const docCount = _react.default.useMemo(() => allTimeseries.reduce((acc, series) => acc + series.data.reduce((acc2, item) => acc2 + (item.doc_count || 0), 0), 0), [allTimeseries]);
  const hasData = docCount > 0;
  const xFormatter = (0, _charts.niceTimeFormatter)([timeState.start, timeState.end]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m",
    className: (0, _css.css)`
        height: ${euiTheme.size.xl};
        white-space: nowrap;
      `
  }, histogramQueryFetch.loading ? /*#__PURE__*/_react.default.createElement(LoadingPlaceholder, null) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    className: (0, _css.css)`
              text-align: right;
            `
  }, hasData ? /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
    value: docCount
  }) : _i18n.i18n.translate('xpack.streams.documentsColumn.noDataLabel', {
    defaultMessage: 'N/A'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    className: (0, _css.css)`
              border-bottom: ${hasData ? '1px solid' : 'none'} ${euiTheme.colors.lightShade};
              display: flex;
              justify-content: center;
              align-items: center;
            `
  }, hasData ? /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      width: '100%',
      height: euiTheme.size.l
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    locale: _i18n.i18n.getLocale(),
    baseTheme: chartBaseTheme,
    theme: {
      background: {
        color: 'transparent'
      }
    },
    xDomain: {
      min: timeState.start,
      max: timeState.end,
      minInterval
    },
    noResults: /*#__PURE__*/_react.default.createElement("div", null)
  }), /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    stickTo: _charts.TooltipStickTo.Middle,
    headerFormatter: ({
      value
    }) => xFormatter(value)
  }), allTimeseries.map(serie => /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    key: serie.id,
    id: serie.id,
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "x",
    yAccessors: ['doc_count'],
    data: serie.data
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "visLine",
    size: "m"
  }))));
}