"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NestedView = NestedView;
var _react = _interopRequireDefault(require("react"));
var _css = require("@emotion/css");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function NestedView({
  children,
  last,
  isBeingDragged
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return isBeingDragged ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children) : /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _css.css)`
        padding-left: ${euiTheme.size.s}; //11px
        margin-left: ${euiTheme.size.s}; //11px
        border-left: ${last ? 'none' : euiTheme.border.thin};
        margin-top: -${euiTheme.size.xs}; //-4px
        padding-top: ${euiTheme.size.xs}; //4px
        position: relative;

        &::before {
          content: '';
          border-bottom: ${euiTheme.border.thin};
          border-left: ${euiTheme.border.thin};
          position: absolute;
          top: 0;
          left: ${last ? '0px' : '-1px'};
          width: ${last ? '9px' : '10px'};
          height: calc(50% + ${euiTheme.size.xs}); // Exactly half of the height of the panel
        }
      `
  }, children);
}