"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamDetailSchemaEditor = void 0;
var _react = _interopRequireDefault(require("react"));
var _streamsSchema = require("@kbn/streams-schema");
var _use_stream_detail = require("../../../hooks/use_stream_detail");
var _schema_editor = require("../schema_editor");
var _use_schema_fields = require("../schema_editor/hooks/use_schema_fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StreamDetailSchemaEditor = ({
  definition,
  refreshDefinition
}) => {
  const {
    loading
  } = (0, _use_stream_detail.useStreamDetail)();
  const {
    fields,
    isLoadingUnmappedFields,
    refreshFields,
    unmapField,
    updateField
  } = (0, _use_schema_fields.useSchemaFields)({
    definition,
    refreshDefinition
  });
  return /*#__PURE__*/_react.default.createElement(_schema_editor.SchemaEditor, {
    fields: fields,
    isLoading: loading || isLoadingUnmappedFields,
    stream: definition.stream,
    onFieldUnmap: unmapField,
    onFieldUpdate: updateField,
    onRefreshData: refreshFields,
    withControls: true,
    withFieldSimulation: true,
    withTableActions: !(0, _streamsSchema.isRootStreamDefinition)(definition.stream) && definition.privileges.manage
  });
};
exports.StreamDetailSchemaEditor = StreamDetailSchemaEditor;