"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManagedBadge = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ManagedBadge = ({
  meta
}) => {
  const theme = (0, _eui.useEuiTheme)();
  if (!(meta !== null && meta !== void 0 && meta.managed)) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    className: (0, _css.css)`
        margin-left: ${theme.euiTheme.size.s};
      `
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.managed', {
    defaultMessage: 'Managed'
  }));
};
exports.ManagedBadge = ManagedBadge;