"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataStreamDetails = DataStreamDetails;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _managed_badge = require("./managed_badge");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const healthToColor = health => {
  switch (health.toLowerCase()) {
    case 'green':
      return 'success';
    case 'yellow':
      return 'warning';
    case 'red':
      return 'danger';
  }
};
function DataStreamHealth({
  health
}) {
  if (!health) {
    return '-';
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: healthToColor(health)
  }, health.toLowerCase());
}
function DataStreamDetails({
  dataStream,
  onFlyoutOpen,
  indexManagementLocator
}) {
  var _dataStream$indices;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    className: (0, _css.css)`
        min-width: 500px;
        max-height: 100px;
      `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.streams.streamDetailView.dataStream', {
    defaultMessage: 'Data stream'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.streams.streamDetailView.dataStreamName', {
    defaultMessage: 'Name'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => onFlyoutOpen((dataStream === null || dataStream === void 0 ? void 0 : dataStream.name) || '')
  }, dataStream ? dataStream.name : '-', /*#__PURE__*/_react.default.createElement(_managed_badge.ManagedBadge, {
    meta: dataStream === null || dataStream === void 0 ? void 0 : dataStream._meta
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.streams.streamDetailView.health', {
    defaultMessage: 'Health'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(DataStreamHealth, {
    health: dataStream === null || dataStream === void 0 ? void 0 : dataStream.status
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.streams.streamDetailView.numberOfIndices', {
    defaultMessage: 'Indices'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: dataStream && (indexManagementLocator === null || indexManagementLocator === void 0 ? void 0 : indexManagementLocator.getRedirectUrl({
      page: 'data_stream_index_list',
      dataStreamName: dataStream.name
    })) || ''
  }, (dataStream === null || dataStream === void 0 ? void 0 : (_dataStream$indices = dataStream.indices) === null || _dataStream$indices === void 0 ? void 0 : _dataStream$indices.length) || '-')), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.streams.streamDetailView.indexMode', {
    defaultMessage: 'Index mode'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, (dataStream === null || dataStream === void 0 ? void 0 : dataStream.index_mode) || '-')))));
}