"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ComponentTemplatePanel = ComponentTemplatePanel;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _css = require("@emotion/css");
var _managed_badge = require("./managed_badge");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ComponentTemplatePanel({
  componentTemplates,
  onFlyoutOpen
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const columns = (0, _react.useMemo)(() => [{
    field: 'name',
    name: _i18n.i18n.translate('xpack.streams.componentTemplatePanel.nameColumn', {
      defaultMessage: 'Name'
    }),
    sortable: true,
    truncateText: true,
    render: (name, record) => {
      var _record$component_tem;
      return /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: () => {
          onFlyoutOpen(name);
        }
      }, name), /*#__PURE__*/_react.default.createElement(_managed_badge.ManagedBadge, {
        meta: (_record$component_tem = record.component_template) === null || _record$component_tem === void 0 ? void 0 : _record$component_tem._meta
      }));
    }
  }, {
    field: 'used_by',
    name: _i18n.i18n.translate('xpack.streams.componentTemplatePanel.usageCountColumn', {
      defaultMessage: 'Usage count'
    }),
    truncateText: true,
    render: (_, record) => record.used_by ? record.used_by.length : 0,
    sortable: ({
      used_by: usedBy
    }) => usedBy.length
  }, {
    field: 'mappings',
    name: _i18n.i18n.translate('xpack.streams.componentTemplatePanel.mappingsColumn', {
      defaultMessage: 'Mappings'
    }),
    render: (_, record) => {
      var _record$component_tem2;
      return (_record$component_tem2 = record.component_template) !== null && _record$component_tem2 !== void 0 && _record$component_tem2.template.mappings ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "check"
      }) : '-';
    }
  }, {
    field: 'settings',
    name: _i18n.i18n.translate('xpack.streams.componentTemplatePanel.settingsColumn', {
      defaultMessage: 'Settings'
    }),
    render: (_, record) => {
      var _record$component_tem3;
      return (_record$component_tem3 = record.component_template) !== null && _record$component_tem3 !== void 0 && _record$component_tem3.template.settings ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "check"
      }) : '-';
    }
  }, {
    field: 'aliases',
    name: _i18n.i18n.translate('xpack.streams.componentTemplatePanel.aliasesColumn', {
      defaultMessage: 'Aliases'
    }),
    render: (_, record) => {
      var _record$component_tem4;
      return /*#__PURE__*/_react.default.createElement("span", null, (_record$component_tem4 = record.component_template) !== null && _record$component_tem4 !== void 0 && _record$component_tem4.template.aliases ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "check"
      }) : '-');
    }
  }], [onFlyoutOpen]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    display: "subdued",
    paddingSize: "l",
    textAlign: "left",
    css: {
      '& [class*="euiCard__description"]': {
        marginTop: '0'
      }
    },
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "m",
      css: {
        fontWeight: euiTheme.font.weight.semiBold
      },
      color: "inherit"
    }, _i18n.i18n.translate('xpack.streams.componentTemplatePanel.title', {
      defaultMessage: 'Component templates'
    })),
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued"
    }, _i18n.i18n.translate('xpack.streams.componentTemplatePanel.description', {
      defaultMessage: 'Reuse settings, mappings, and aliases configurations in multiple index templates.'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: "https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-put-component-template",
      target: "_blank",
      external: false,
      color: "subdued",
      css: {
        textDecoration: 'underline',
        fontWeight: euiTheme.font.weight.regular
      }
    }, _i18n.i18n.translate('xpack.streams.componentTemplatePanel.learnMore', {
      defaultMessage: 'Learn more.'
    })))
  }, componentTemplates && /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: componentTemplates,
    columns: columns,
    tableLayout: 'auto',
    className: (0, _css.css)`
            margin: ${euiTheme.size.l} -${euiTheme.size.s} 0;
            & .euiTable {
              border-radius: ${euiTheme.border.radius.small};
            }
          `
  }));
}