"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.selectUnsupportedDottedFields = exports.selectPreviewDocuments = void 0;
var _reselect = require("reselect");
var _lodash = require("lodash");
var _objectUtils = require("@kbn/object-utils");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EMPTY_ARRAY = [];

/**
 * Selects the documents used for the data preview table.
 */
const selectPreviewDocuments = exports.selectPreviewDocuments = (0, _reselect.createSelector)([context => context === null || context === void 0 ? void 0 : context.samples, context => context === null || context === void 0 ? void 0 : context.previewDocsFilter, context => {
  var _context$simulation;
  return context === null || context === void 0 ? void 0 : (_context$simulation = context.simulation) === null || _context$simulation === void 0 ? void 0 : _context$simulation.documents;
}], (samples, previewDocsFilter, documents) => {
  return (previewDocsFilter && documents ? (0, _utils.filterSimulationDocuments)(documents, previewDocsFilter) : samples === null || samples === void 0 ? void 0 : samples.map(_objectUtils.flattenObjectNestedLast)) || EMPTY_ARRAY;
});

/**
 * Selects the set of dotted fields that are not supported by the current simulation.
 */
const selectUnsupportedDottedFields = exports.selectUnsupportedDottedFields = (0, _reselect.createSelector)([context => context.samples], samples => {
  const properties = samples.flatMap(getDottedFieldPrefixes);
  return (0, _lodash.uniq)(properties);
});
const isPlainObj = _lodash.isPlainObject;

/**
 * Returns a list of all dotted properties prefixes in the given object.
 */
function getDottedFieldPrefixes(obj) {
  const result = [];
  function traverse(currentObj, path) {
    let foundDot = false;
    for (const key in currentObj) {
      if (Object.hasOwn(currentObj, key)) {
        const value = currentObj[key];
        const newPath = [...path, key];

        // Check if current key contains a dot
        if (key.includes('.')) {
          const newKey = newPath.join('.');
          // For objects with dotted keys, add trailing dot
          if (isPlainObj(value)) {
            result.push(newKey.concat('.'));
          } else {
            result.push(newKey);
          }
          foundDot = true;
          continue; // Skip further traversal for this key
        }

        // If it's an object, traverse deeper
        if (isPlainObj(value) && traverse(value, newPath)) {
          // If traversal found a dot, don't continue with siblings
          foundDot = true;
          continue;
        }
      }
    }
    return foundDot;
  }
  traverse(obj, []);
  return result;
}