"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JsonEditor = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _eui = require("@elastic/eui");
var _codeEditor = require("@kbn/code-editor");
var _i18n = require("@kbn/i18n");
var _streamsSchema = require("@kbn/streams-schema");
var _i18nReact = require("@kbn/i18n-react");
var _use_kibana = require("../../../../../hooks/use_kibana");
var _helpers = require("../../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const JsonEditor = () => {
  var _fieldState$error;
  const {
    core: {
      docLinks
    }
  } = (0, _use_kibana.useKibana)();
  const {
    field,
    fieldState
  } = (0, _reactHookForm.useController)({
    name: 'processors',
    rules: {
      validate: value => {
        if (typeof value === 'string') {
          return _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.ingestPipelineProcessorsInvalidJSON', {
            defaultMessage: 'Invalid JSON format'
          });
        }
        if (!Array.isArray(value)) {
          return _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.ingestPipelineProcessorsInvalidArray', {
            defaultMessage: 'Expected an array'
          });
        }
        const invalidProcessor = value.find(processor => {
          const processorType = Object.keys(processor)[0];
          return !_streamsSchema.elasticsearchProcessorTypes.includes(processorType);
        });
        if (invalidProcessor) {
          return _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.ingestPipelineProcessorsInvalidProcessorType', {
            defaultMessage: 'Invalid processor type: {processorType}',
            values: {
              processorType: Object.keys(invalidProcessor)[0]
            }
          });
        }
      }
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.ingestPipelineProcessorsLabel', {
      defaultMessage: 'Ingest pipeline processors'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.ingestPipelineProcessorsHelpText",
      defaultMessage: 'A JSON-encoded array of {ingestPipelineProcessors}. {conditions} defined in the processor JSON take precedence over conditions defined in "Optional fields".',
      values: {
        ingestPipelineProcessors: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks.links.ingest.processors,
          target: "_blank",
          external: true
        }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.ingestPipelineProcessorsLabel', {
          defaultMessage: 'ingest pipeline processors'
        })),
        conditions: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks.links.ingest.conditionalProcessor,
          target: "_blank",
          external: true
        }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.ingestPipelineProcessorsConditionallyLabel', {
          defaultMessage: 'Conditions'
        }))
      }
    }),
    error: (_fieldState$error = fieldState.error) === null || _fieldState$error === void 0 ? void 0 : _fieldState$error.message,
    isInvalid: fieldState.invalid,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    value: (0, _helpers.serializeXJson)(field.value, '[]'),
    onChange: value => field.onChange((0, _helpers.deserializeJson)(value)),
    languageId: "xjson",
    height: 200,
    "aria-label": _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.ingestPipelineProcessorsAriaLabel', {
      defaultMessage: 'Ingest pipeline processors editor'
    })
  }));
};
exports.JsonEditor = JsonEditor;