"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IgnoreMissingToggle = exports.IgnoreFailureToggle = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _reactHookForm = require("react-hook-form");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _toggle_field = require("./toggle_field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IgnoreFailureToggle = () => {
  const value = (0, _reactHookForm.useWatch)({
    name: 'ignore_failure'
  });
  return /*#__PURE__*/_react.default.createElement(_toggle_field.ToggleField, {
    name: "ignore_failure",
    label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.ignoreFailuresLabel', {
      defaultMessage: 'Ignore failures for this processor'
    }),
    helpText: !value ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      component: "span",
      size: "relative",
      color: "warning"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.ignoreFailuresWarning",
      defaultMessage: "Disabling the {ignoreField} option could lead to unexpected pipeline failures.",
      values: {
        ignoreField: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "ignore_failure")
      }
    })) : undefined
  });
};
exports.IgnoreFailureToggle = IgnoreFailureToggle;
const IgnoreMissingToggle = () => {
  return /*#__PURE__*/_react.default.createElement(_toggle_field.ToggleField, {
    name: "ignore_missing",
    label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.ignoreMissingLabel', {
      defaultMessage: 'Ignore missing'
    }),
    helpText: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.ignoreMissingHelpText', {
      defaultMessage: 'Ignore documents with a missing field.'
    })
  });
};
exports.IgnoreMissingToggle = IgnoreMissingToggle;