"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GeneratePatternButton = exports.AdditionalChargesCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactHooks = require("@kbn/react-hooks");
var _i18nReact = require("@kbn/i18n-react");
var _use_kibana = require("../../../../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GeneratePatternButton = ({
  aiFeatures,
  onClick,
  isLoading,
  isDisabled
}) => {
  const {
    core: {
      http
    }
  } = (0, _use_kibana.useKibana)();
  const [isPopoverOpen, {
    off: closePopover,
    toggle: togglePopover
  }] = (0, _reactHooks.useBoolean)(false);
  const splitButtonPopoverId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'splitButtonPopover'
  });
  if (!aiFeatures.enabled) {
    if (aiFeatures.couldBeEnabled) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processorFlyout.aiAssistantNotEnabledTooltip', {
          defaultMessage: 'AI Assistant features are not enabled. To enable features, add an AI connector on the management page.'
        })
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: http.basePath.prepend(`/app/management/insightsAndAlerting/triggersActionsConnectors/connectors`)
      }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processorFlyout.aiAssistantNotEnabled', {
        defaultMessage: 'Enable AI Assistant features'
      })));
    }
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "xs",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    iconType: "sparkles",
    "data-test-subj": "streamsAppGrokAiSuggestionsRefreshSuggestionsButton",
    onClick: () => onClick(aiFeatures.genAiConnectors.selectedConnector),
    isLoading: isLoading,
    isDisabled: !aiFeatures.genAiConnectors.selectedConnector || isDisabled
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processorFlyout.refreshSuggestions', {
    defaultMessage: 'Generate pattern'
  }))), aiFeatures.genAiConnectors.connectors && aiFeatures.genAiConnectors.connectors.length >= 2 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: splitButtonPopoverId,
    isOpen: isPopoverOpen,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "streamsAppGrokAiPickConnectorButton",
      onClick: togglePopover,
      display: "base",
      size: "s",
      iconType: "boxesVertical",
      "aria-label": _i18n.i18n.translate('xpack.streams.refreshButton.euiButtonIcon.moreLabel', {
        defaultMessage: 'More'
      })
    }),
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: aiFeatures.genAiConnectors.connectors.map(connector => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: connector.id,
      icon: connector.id === aiFeatures.genAiConnectors.selectedConnector ? 'check' : 'empty',
      onClick: () => {
        aiFeatures.genAiConnectors.selectConnector(connector.id);
        closePopover();
      }
    }, connector.name))
  })))));
};
exports.GeneratePatternButton = GeneratePatternButton;
const AdditionalChargesCallout = ({
  aiFeatures
}) => {
  const {
    core: {
      docLinks
    }
  } = (0, _use_kibana.useKibana)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    onDismiss: () => aiFeatures.acknowledgeAdditionalCharges(true)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.streamDetailView.managementTab.enrichment.processorFlyout.managedConnectorTooltip",
    defaultMessage: "Elastic Managed LLM is the new default for generating patterns and incurs <costLink>additional charges</costLink>. Other LLM connectors remain available. <learnMoreLink>Learn more</learnMoreLink>",
    values: {
      costLink: (...chunks) => {
        var _docLinks$links, _docLinks$links$obser;
        return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks === null || docLinks === void 0 ? void 0 : (_docLinks$links = docLinks.links) === null || _docLinks$links === void 0 ? void 0 : (_docLinks$links$obser = _docLinks$links.observability) === null || _docLinks$links$obser === void 0 ? void 0 : _docLinks$links$obser.elasticManagedLlmUsageCost,
          target: "_blank",
          rel: "noopener noreferrer",
          external: true
        }, chunks);
      },
      learnMoreLink: (...chunks) => {
        var _docLinks$links2, _docLinks$links2$obse;
        return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks === null || docLinks === void 0 ? void 0 : (_docLinks$links2 = docLinks.links) === null || _docLinks$links2 === void 0 ? void 0 : (_docLinks$links2$obse = _docLinks$links2.observability) === null || _docLinks$links2$obse === void 0 ? void 0 : _docLinks$links2$obse.elasticManagedLlm,
          target: "_blank",
          rel: "noopener noreferrer",
          external: true
        }, chunks);
      }
    }
  }));
};
exports.AdditionalChargesCallout = AdditionalChargesCallout;