"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConvertProcessorToFormState = exports.getConvertFormStateToConfig = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getConvertFormStateToConfig = (key, fieldConfigurations, fieldOptions) => {
  return formState => {
    const state = Object.keys(formState).reduce((acc, field) => {
      const value = formState[field];
      if (field === 'field') {
        acc.field = value;
      } else if (field === 'ignore_failure' && fieldOptions.includeIgnoreFailures) {
        acc.ignore_failure = value;
      } else if (field === 'ignore_missing' && fieldOptions.includeIgnoreMissing) {
        acc.ignore_missing = value;
      } else if (field === 'if' && fieldOptions.includeCondition) {
        acc.if = value;
      } else {
        const fieldConfig = fieldConfigurations.find(config => config.field === field);
        if (!fieldConfig) {
          return acc;
        }
        if (fieldConfig.type === 'boolean') {
          acc[field] = value;
        } else if (fieldConfig.type === 'array' || fieldConfig.type === 'string') {
          if (fieldConfig.required) {
            acc[field] = value;
          } else {
            acc[field] = (0, _lodash.isEmpty)(value) ? undefined : value;
          }
        }
      }
      return acc;
    }, {});
    return {
      [key]: state
    };
  };
};
exports.getConvertFormStateToConfig = getConvertFormStateToConfig;
const getConvertProcessorToFormState = (key, defaultFormState) => {
  return processorState => {
    const processor = processorState[key];
    const values = Object.keys(processor).reduce((acc, field) => {
      const value = processor[field];
      if (value !== undefined) {
        acc[field] = value;
      }
      return acc;
    }, {
      ...defaultFormState
    });
    return structuredClone({
      ...values,
      type: key
    });
  };
};
exports.getConvertProcessorToFormState = getConvertProcessorToFormState;