"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.urlDecodeProcessorConfig = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _condition = require("../../../../../../util/condition");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultFormState = {
  type: 'urldecode',
  field: '',
  target_field: '',
  ignore_missing: false,
  ignore_failure: false,
  if: _condition.ALWAYS_CONDITION
};
const fieldOptions = {
  fieldHelpText: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.urlDecodeFieldHelpText', {
    defaultMessage: 'The field to decode.'
  }),
  includeCondition: true,
  includeIgnoreFailures: true,
  includeIgnoreMissing: true
};
const fieldConfigurations = [{
  field: 'target_field',
  type: 'string',
  required: false,
  label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.urlDecodeTargetFieldLabel', {
    defaultMessage: 'Target field'
  }),
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.urlDecodeTargetFieldHelpText",
    defaultMessage: "The field to assign the converted value to, by default {field} is updated in-place.",
    values: {
      field: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "field")
    }
  })
}];
const urlDecodeProcessorConfig = exports.urlDecodeProcessorConfig = {
  type: 'urldecode',
  inputDisplay: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.urlDecodeInputDisplay', {
    defaultMessage: 'URL Decode'
  }),
  getDocUrl: esDocUrl => {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.urlDecodeHelpText",
      defaultMessage: "{urlDecodeLink} If the field is an array of strings, all members of the array will be decoded.",
      values: {
        urlDecodeLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "streamsAppAvailableProcessorsUrlDecodeLink",
          external: true,
          target: "_blank",
          href: esDocUrl + 'urldecode-processor.html'
        }, _i18n.i18n.translate('xpack.streams.availableProcessors.urlDecodeLinkLabel', {
          defaultMessage: 'URL-decodes a string.'
        }))
      }
    });
  },
  defaultFormState,
  convertFormStateToConfig: (0, _utils.getConvertFormStateToConfig)('urldecode', fieldConfigurations, fieldOptions),
  convertProcessorToFormState: (0, _utils.getConvertProcessorToFormState)('urldecode', defaultFormState),
  fieldConfigurations,
  fieldOptions
};