"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.typeSupportsFormat = exports.FieldFormFormat = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _useToggle = _interopRequireDefault(require("react-use/lib/useToggle"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_FORMAT = 'strict_date_optional_time||epoch_millis';
const POPULAR_FORMATS = [DEFAULT_FORMAT, 'strict_date_optional_time', 'date_optional_time', 'epoch_millis', 'basic_date_time'];
const typeSupportsFormat = type => {
  if (!type) return false;
  return ['date'].includes(type);
};
exports.typeSupportsFormat = typeSupportsFormat;
const FieldFormFormat = props => {
  if (!typeSupportsFormat(props.field.type)) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(FieldFormFormatSelection, props);
};
exports.FieldFormFormat = FieldFormFormat;
const FieldFormFormatSelection = props => {
  const [isFreeform, toggleIsFreeform] = (0, _useToggle.default)(props.field.format !== undefined && !isPopularFormat(props.field.format));
  const onToggle = (0, _react.useCallback)(e => {
    if (!e.target.checked && !isPopularFormat(props.field.format)) {
      props.onChange(undefined);
    }
    toggleIsFreeform();
  }, [props, toggleIsFreeform]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, isFreeform ? /*#__PURE__*/_react.default.createElement(FreeformFormatInput, props) : /*#__PURE__*/_react.default.createElement(PopularFormatsSelector, props)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.streams.fieldFormFormatSelection.freeformToggleLabel', {
      defaultMessage: 'Use freeform mode'
    }),
    checked: isFreeform,
    onChange: onToggle
  })));
};
const PopularFormatsSelector = props => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    hasNoInitialSelection: props.field.format === undefined || !isPopularFormat(props.field.format),
    "data-test-subj": "streamsAppSchemaEditorFieldFormatPopularFormats",
    onChange: event => {
      props.onChange(event.target.value);
    },
    value: props.field.format,
    options: POPULAR_FORMATS.map(format => ({
      text: format,
      value: format
    }))
  });
};
const FreeformFormatInput = props => {
  var _props$field$format;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "streamsAppFieldFormFormatField",
    placeholder: "yyyy/MM/dd",
    value: (_props$field$format = props.field.format) !== null && _props$field$format !== void 0 ? _props$field$format : '',
    onChange: e => props.onChange(e.target.value)
  });
};
const isPopularFormat = value => {
  return POPULAR_FORMATS.includes(value);
};