"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldTypeFilterGroup = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _filter_group = require("./filter_group");
var _constants = require("../constants");
var _schema_editor_context = require("../schema_editor_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BUTTON_LABEL = _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditor.fieldTypeFilterGroupButtonLabel', {
  defaultMessage: 'Type'
});
const FieldTypeFilterGroup = ({
  onChange
}) => {
  const {
    fields
  } = (0, _schema_editor_context.useSchemaEditorContext)();
  const fieldTypes = (0, _react.useMemo)(() => (0, _lodash.uniq)(fields.map(field => field.type).filter(type => type !== undefined)), [fields]);
  const [items, setItems] = (0, _react.useState)(() => getTypeOptions(fieldTypes));

  // This side effect is due to the fact that the available field status can be updated once the unmapped fields are fetched.
  (0, _react.useEffect)(() => {
    setItems(prevItems => {
      const prevSelection = new Map(prevItems.map(item => [item.key, item.checked]));
      const nextItems = getTypeOptions(fieldTypes);
      nextItems.forEach(item => {
        if (prevSelection.has(item.key)) {
          item.checked = prevSelection.get(item.key);
        }
      });
      return nextItems;
    });
  }, [fieldTypes]);
  const onChangeItems = (0, _react.useCallback)(nextItems => {
    setItems(nextItems);
    onChange({
      type: nextItems.filter(nextItem => nextItem.checked === 'on').map(item => item.key)
    });
  }, [onChange]);
  return /*#__PURE__*/_react.default.createElement(_filter_group.FilterGroup, {
    items: items,
    filterGroupButtonLabel: BUTTON_LABEL,
    onChange: onChangeItems
  });
};
exports.FieldTypeFilterGroup = FieldTypeFilterGroup;
const getTypeOptions = fieldStatus => {
  return fieldStatus.map(key => ({
    label: _constants.FIELD_TYPE_MAP[key].label,
    key
  }));
};